<?php

class MySQLiSession {
    const USERNAME = "user";
    const PASSWORD = "secret";
    const HOST = "localhost";
    const DATABASE = "unleashed";
    const TABLE = "session_data";
    const SESS_NAME = "UNLEASHED";
    const SESS_EXPIRE = 3600; /* sekundy */

    private $link;
    private $name;
    private $table;

    function __construct($user = null, $pass = null,
                         $host = null, $db = null,
                         $table = null, $sess_name = null)
    {
        $user = (is_null($user)) ? self::USERNAME : $user;
        $pass = (is_null($pass)) ? self::PASSWORD : $pass;
        $host = (is_null($host)) ? self::HOST : $host;
        $db = (is_null($db)) ? self::DATABASE : $db;
        $this->table = (is_null($table)) ? self::TABLE : $table;
        $this->name = (is_null($sess_name)) ? self::SESS_NAME : $sess_name;

        $this->link = mysqli_connect($host, $user, $pass, $db);

        if(!$this->link) {
            throw new Exception("Nie mona nawiza poczenia z baz danych!");
            return;
        }

        mysqli_select_db($this->link, $db);

        session_set_save_handler(array($this, "handler_open"),
                                 array($this, "handler_close"),
                                 array($this, "handler_read"),
                                 array($this, "handler_write"),
                                 array($this, "handler_destroy"),
                                 array($this, "handler_garbage"));

        session_name($this->name);
        session_start();

    }

    public function handler_open($path, $sess_name)
    {
        $this->name = $sess_name;
        return true;
    }  

    public function handler_close()
    {
        return true;
    }
    
    public function handler_write($sess_id, $data)
    {
        $query = "INSERT INTO {$this->table} (id, data)
                  VALUES (?, ?)
                  ON DUPLICATE KEY
                  UPDATE data = ?,
                  last_updated=NULL";

        $stmt = mysqli_prepare($this->link, $query);

        mysqli_bind_param($stmt, "sss", $sess_id, $data, $data);

        return mysqli_execute($stmt);

    }
    
    public function handler_read($sess_id)
    {
        $query = "SELECT data
                  FROM {$this->table}
                  WHERE id = ?
                  AND UNIX_TIMESTAMP(last_updated) + " .
                  self::SESS_EXPIRE . " > UNIX_TIMESTAMP(NOW())";

        $stmt = mysqli_prepare($this->link, $query);

        mysqli_bind_param($stmt, "s", $sess_id);

        if(mysqli_execute($stmt)) {
            mysqli_bind_result($stmt, $retval);

            mysqli_fetch($stmt);

            if(!empty($retval)) {
                return $retval;
            }

        }
        return "";
    }   

    public function handler_destroy($sess_id)
    {
        $query = "DELETE FROM {$this->table} WHERE id = ?";

        $stmt = mysqli_prepare($this->link, $query);

        mysqli_bind_param($stmt, "s", $sess_id);

        return mysqli_execute($stmt);
    }

    public function handler_garbage($max_life)
    {
        $query = "DELETE FROM {$this->table}
                  WHERE UNIX_TIMESTAMP(last_updated) + " .
                  self::SESS_EXPIRE . " <= UNIX_TIMESTAMP(NOW())";

        mysqli_query($this->link, $query);

        return;
    }   

} 
 
?>