<?php
    declare(ticks = 1);
    /* Definicje acuchowych odpowiednikw poszczeglnych sygnaw */
    $signals = array(SIGHUP => "SIGHUP", SIGINT => "SIGINT",
                     SIGQUIT => "SIGQUIT", SIGILL => "SIGILL",
                     SIGTRAP => "SIGTRAP", SIGABRT => "SIGABRT",
                     SIGIOT => "SIGIOT", SIGBUS => "SIGBUS",
                     SIGFPE => "SIGFPE", SIGPROF => "SIGPROF",
                     SIGUSR1 => "SIGUSR1", SIGSEGV => "SIGSEGV",
                     SIGUSR2 => "SIGUSR2", SIGPIPE => "SIGPIPE",
                     SIGALRM => "SIGALRM", SIGTERM => "SIGTERM",
                     SIGSTKFLT => "SIGSTKFLT", SIGCLD => "SIGCLD",
                     SIGTTIN => "SIGTTIN", SIGTTOU => "SIGTTOUT",
                     SIGURG => "SIGURG", SIGXCPU => "SIGXCPU",
                     SIGXFSZ => "SIGXFSZ", SIGVTALRM => "SIGVTALRM",
                     SIGWINCH => "SIGWINCH", SIGPOLL => "SIGPOLL",
                     SIGIO => "SIGIO", SIGPWR => "SIGPWR",
                     SIGSYS => "SIGSYS", SIGBABY => "SIGBABY");

    /* Funkcja obsugi sygnaw w procesie nadrzdnym */
    function parent_signal_handler($signal_id) {
        global $signals;
        $pid = posix_getpid();
        $time = date("h:i:s");
        echo "$time: Proces nadrzdny odebra sygna {$signals[$signal_id]}..\n";
    }

    /* Funkcja obsugi sygnaw w procesie podrzdnnym */
    function child_signal_handler($signal_id) {
        global $signals;
        $ppid = posix_getppid();
        $time = date("h:i:s");
        echo "$time: Proces podrzdny odebra sygna " .
             "{$signals[$signal_id]}..\n";
        /* Przesanie sygnau SIGUSR1 do procesu nadrzdnego jeli 
           jeli do procesu podrzdnego przesano sygnay SIGTERM lub SIGUSR1 */
        switch ($signal_id) {
            case SIGTERM:
            case SIGUSR1:
                echo "Koczymy dziaanie aplikacji..\n";
                posix_kill($ppid, SIGUSR1);
                exit;
        }   
    }

    /* Rozwidlenie procesw */
    $child = pcntl_fork();
    if($child == -1) {
        die("Nie mona rozwidli procesu.");
    }
    if($child) { /* To jest proces nadrzdny */
        $pid = posix_getpid();
        /* Rejestracja funkcji obsugi sygnaw */
        foreach($signals as $sig => $sig_str) {
            @pcntl_signal($sig, "parent_signal_handler");
        }
        /* Odczekanie 5 sekund i przesanie syganu SIGUSR2 do procesu
           podrzdnego */
        sleep(5);
        posix_kill($child, SIGUSR2);
        /* Odczekanie kolejnych 5 sekund i wysanie sygnau SIGUSR1 
           do procesu podrzdnego */
        sleep(5);
        posix_kill($child, SIGUSR1);
        /* Oczekiwanie na zakoczenie procesu podrzdnego */
        pcntl_waitpid($child, $status);
        echo "Koczenie procesu nadrzdnego.\n";
    } else { /* To jest proces podrzdny */
        /* Rejestracja funkcji obsugi sygnaw */
        foreach($signals as $sig => $sig_str) {
            @pcntl_signal($sig, "child_signal_handler");
        }
        $ppid = posix_getppid();
        /* Wysyanie sygnau SIGUSR2 do porcesu nadrzdnego
           co trzy sekundy */
        while(1) {
            sleep(3);
            posix_kill($ppid, SIGUSR2);
        }
    }
?>