<?php
  interface printable {
    public function printme();
  }

  abstract class Number {
    private $value;
    abstract public function value();
    public function reset() {
      $this->value = NULL;
    }
  }

  class Integer extends Number implements printable {
    private $value;
    function __construct($value) {
      $this->value = $value;
    }
    public function getValue() {
      return (int)$this->value;
    }
    public function printme() {
      echo (int)$this->value;
    }
  }
  
  /* Tworzy funkcj, ktra wymaga interfejsu printable. */
  function printNumber(printable $myObject) {
    /* Jeeli funkcja ta zostanie wywoana, moemy by pewni,
       e istnieje metoda print() */
    $myObject->printme();
  }
  $inst = new Integer(10);
  printNumber($inst);
?>