<?php

    /********** POCZTEK SKRYPTU WERYFIKACJI FORMULARZY ***********/     
    $form_errors = array();
    $form_errorlist = false;
       
    function add_error($error) {        
        global $form_errorlist, $form_errors;
        $form_errorlist = true;
        $form_errors[] = $error;
    }
    
    function _process_form($method) {
        
        /** Ta funkcja jest wywoywana wycznie przez funkcj validate_form()! */
        
        /* Sprawdzamy czy istnieje funkcja process_form(). Jeli taka funkcja
           nie istnieje, to usuwanie niepotrzebnych pl formularza nie ma 
           sensu. */
        if(function_exists("process_form")) {

            /* Tworzymy kopi przesanych danych i przegldamy j usuwajc
               jednoczenie wszystkie elementy pomocnicze. */
            $data = $method;
            foreach($data as $key=>$val) {
                    
                if(preg_match("/(submit|required)|(_desc$)/i", $key) == 1)
                    unset($data[$key]);
            }

            /* Wywoujemy funkcj process_form() i przekazujemy do niej
               "oczyszczon" wersje danych przesanych z formularza */
            process_form($data);
        }
    }
    
    function validate_form($method) {
    
        /* Ta zmienna okrela czy podczas wykonywania funkcji 
           wystpiy jakiekolwiek bdy. Domylnie zakadamy, e
           formularz jest poprawny */
        $process = true;
        
        /* Sprawdzamy czy istnieje pole 'required'. Jeli ten element
           nie istnieje, to automatycznie zakadamy, e formularz 
           nie jest poprawny. */
        if(!isset($method['required'])) {
           
           add_error("Nie mona odszuka wymaganego pola ukrytego o nazwie 'required'!");
           $process = false;
        } else {
            
            /* Okrelamy nazwy wymaganych elementw formularza
               zapisane w polu 'required' i zapisujemy je w tablicy. */
            $required = explode(',',$method['required']);

            /* Sprawdzamy czy istniej wszystkie wymagane pola 
               formularza, oraz czy dla kadego z nich podano jak
               warto (czy pole nie jest puste). */
            foreach($required as $val) {
                if(empty($method[$val])) {
                    
                    /* Ten konkretny element powinien zawiera dane, lecz 
                       z jakiego powodu jest pusty. Dlatego te prbujemy
                       pobra zrozumiay dla uytkownika opis tego elementu
                       i wywietli stosowny komunikat o bdzie.
                       Jeli nie podano adego konkretnego komunikatu, to jest on
                       generowany na podstawie nazwy elementu. */
                    if(isset($method[$val."_desc"])) {
                        $errormsg = "Nie podano wartoci pola wymaganego '{$method[$val."_desc"]}'!";
                    } else {
                        $errormsg = "Wymagane pole '$val' byo puste!";
                    }
                    add_error($errormsg);
                    $process = false;
                }
            }
            
            /* Rozpoczynamy sprawdzanie poszczeglnych elementw formularza. */
            foreach($method as $key=>$val) {

                /* Poniewa interesuje nas weryfikacja jedynie tych pl formularza
                   w ktrych uytkownik co podaje, zatem podczas sprawdzania
                   pomijamy elementy o nazwach 'submit', 'required' oraz te,
                   ktrych nazwy kocz si acuchem znakw '_desc'. */
                if(preg_match("/(submit|required)|(_desc$)/i", $key) != 1) {
                    
                    /* Tworzymy nazw funkcji, ktra zostanie wywoana w celu 
                       okrelenia poprawnoci analizowanego pola. */
                    $func = $key."_validate";
                    
                    /* Sprawdzamy czy istnieje funkcja do weryfikacji konkretnego 
                       elementu formularza. */
                    if(function_exists($func)) {

                        /* Funkcja istnieje, zatem wywoujemy j przekazujc 
                           do niej warto elementu formularza oraz opis zrozumiay
                           dla uytkownika (jeli zosta zdefiniowany). */
                        if(!isset($method[$key."_desc"])) {
                            $result = $func($val, $key);
                        } else {
                            $result = $func($val, $method[$key."_desc"]);
                        }
                        
                        /* Jeli funkcja suca do weryfikacji poprawnoci pola
                           nie zwrci wartoci true, oznacza to e warto pola
                           nie jest poprawna, a zmienna $return zawiera komunikat
                           o bdzie. Komunikat ten dodajemy do listy zawierajcej
                           komunikaty o wszystkich zaistniaych bdach. */
                          
                        if($result !== true) {
                            add_error($result);
                            $process = false;
                        }
                    }
                }
            }
        }       
        
        /* Jeli podczas weryfikacji formularza nie wystpiy adne 
           bdy, to zmienna $process wci powinna mie warto true.
           W takim przypadku wywoujemy funkcj _process_form(), 
           przekazujc do niej sprawdzone dane, a nastpnie
           koczymy dziaanie funkcji zwracajc warto true. */
        if($process) {
            _process_form($method);
            return true;
        }
        
        /* Podczas weryfikacji formularza wystpiy bdy, zwracamy 
           warto false */
        return false;
    }
         
    /********** KONIEC SKRYPTU WERYFIKACJI FORMULARZY ***********/
    /********** POCZTEK FUNKCJI DEFINIOWANYCH PRZEZ UYTKOWNIKA ***********/
    
    /* Ponisze rozwizanie to tylko uatwienie. Jednka wycznie 
       korzystanie ze zmiennej $method podczas odwoywania si 
       do tablic superglobalnych pozwala nam szybko zmienia
       metod przesyania formularza z GET na POST i odwrotnie,
       bez koniecznoci wprowadzania wielu modyfikacji w skrypcie.
     */
       
    $method = &$_GET;

    /* Sprawdzamy czy formularz zosta przesany, jeli tak to
       zaczynamy proces weryfikacji. */
    if(isset($method['submit'])) {
        validate_form($method);        
    }
   
    /* Ta funkcja jest wywoywana przez funkcj validate_form() 
       w celu sprawdzenia poprawnoci pola o nazwie 'email'. */
        
    function email_validate($data, $desc) {
        $regex = "/^[a-z0-9\._-]+@+[a-z0-9\._-]+\.+[a-z]{2,3}$/i";
        if(preg_match($regex, $data) != 1)
            return "Warto pola '$desc' jest nieprawidowa.";
            
        return true;
    }

    /* Ta funkcja jest wywoywana przez funkcj validate_form() 
       po pomylnym zakoczeniu weryfikacji formularza. */
    function process_form($data) {
        
      $msg = "W formularzu ze strony {$_SERVER['PHP_SELF']} zostay podane nastpujce wartoci: \n\n";
      foreach($data as $key=>$val) {
          $msg .= "$key => $val\n";
      }
      mail("wielkibrat@jakisserwer.com.pl", "Przesano formularz", $msg);
              
    } 
    /********** KONIEC FUNKCJI DEFINIOWANYCH PRZEZ UYTKOWNIKA ***********/
    
?>
<HTML>
<HEAD><TITLE>Przykad weryfikacji formularza</TITLE></HEAD>
<BODY>
<?php 
    /* Wywietlamy wszystkie bdy wykryte podczas weryfikacji */

    if($form_errorlist): ?>
    Prosz poprawi nastpujce bdy:<BR>
    <UL>
    <?php foreach($form_errors as $val): ?>
    <LI><?=$val?>
    <?php endforeach; ?>
    </UL> 
<?php endif; ?>
<FORM ACTION="<?php echo $_SERVER['PHP_SELF']; ?>" METHOD=GET>
<INPUT TYPE="hidden" NAME="required" VALUE="first,last,email">
<INPUT TYPE="hidden" NAME="submit" VALUE="1">
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>
<TR>
    <TD COLSPAN=2>Prosz wypeni nastpujce pola. (* = Wymagane)</TD>
</TR>
<TR>
    <TD>*Imi:</TD>
    <TD><INPUT TYPE="text" NAME="first" VALUE="<?php echo @$method['first']; ?>">
        <INPUT TYPE="hidden" NAME="first_desc" VALUE="Imi"></TD>
</TR>
<TR>
    <TD>*Nazwisko:</TD>
    <TD><INPUT TYPE="text" NAME="last" VALUE="<?php echo @$method['last']; ?>">
        <INPUT TYPE="hidden" NAME="last_desc" VALUE="Nazwisko"></TD>
</TR>
<TR>
    <TD>Telefon:</TD>
    <TD><INPUT TYPE="text" NAME="phone" VALUE="<?php echo @$method['phone']; ?>">
        <INPUT TYPE="hidden" NAME="phone_desc" VALUE="Numer telefonu"></TD>
</TR>
<TR>
    <TD>*E-mail:</TD>
    <TD><INPUT TYPE="text" NAME="email" VALUE="<?php echo @$method['email']; ?>">
        <INPUT TYPE="hidden" NAME="email_desc" VALUE="Adres e-mail"></TD>
</TR>
<TR>
    <TD COLSPAN=2><INPUT TYPE="submit" VALUE="Wylij"></TD>
</TR>
</TABLE>
</FORM>
</BODY>
</HTML>
