<?php

$start = array(tytul => "<h2>");

$end = array(tytul => "</h2><br>",
             slowakluczowe => "<br>",
             opis => "<br>");

$que[last] = '';

$doc = xmldocfile('tst.xml');

// Wze gwny
$root = $doc->root();

process_node($root);

function process_node($node) {
    global $que, $start, $end;
    switch ($node->type) {
        case XML_ELEMENT_NODE:
            switch (($name = strtolower(trim($node->tagname)))) {
                case 'witryna':
                    print '<br>';
                    $que[last] = "";
                    break;
                case 'tytul':
                    print $start[tytul];
                    $que[last] = $name;
                    break;
                case 'opis':
                case 'slowakluczowe':
                    $que[last] = $name;
                    $name = ucfirst($name);
                    print "<b>${name}:</b>: ";
                    break;
                default:
                    $que[last] = "";
                    break;
            }
        case XML_TEXT_NODE:
            if (!empty($que[last])) {
                print $node->get_content() . $end[$que[last]];
            }
            $que[last] = '';
            break;
    }

    $children = $node->children();
    if (is_array($children)) {
        foreach($children as $child) {
            process_node($child);
        }
    }
}
?>