<?php

function is_leap_year ($year)
{
    return ((($year%4) == 0 && ($year%100)!=0) || ($year%400)==0);
}

function is_valid_date ($date)
{
    /* Podziel dat na czci. */
    list($month, $day, $year) = explode('/', $date);
    $month_days = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

    if ($month < 1 || $month > 12)
        return false;

    /* Rok musi si skada z czterech cyfr. */
    if ((strlen($year) != 4) || eregi("[^0-9]", $year))
        return false;

    /* Jeli jest rok przestpny, luty bdzie mia 29 dni. */
    if (is_leap_year($year))
        $month_days[1] = 29;

    if ($day < 1 || $day > $month_days[$month - 1])
        return false;

    return true;
}
?>