<?php
/**
 * Klasa suca do wysyania wiadomoci w HTML-u.
 *
 * @author Sterling Hughes <sterling@php.net>
 */
class HTML_Email extends MIME {

    // {{{ HTML_Email()

    /**
     * Konstruktor dodajcy do wiadomoci pola To, From i Subject
     *
     * @param $to string Do kogo wysyasz wiadomo.
     * @param $from string Od kogo jest ta wiadomo.
     * @param $subject string Temat wiadomoci.
     *
     * @return object Nowy obiekt HTML_Email
     */
    function HTML_Email ($to, $from, $subject) {
        $this->MIME($to, $from, $subject);
    }

    // }}}
    // {{{ html_data()

    /**
     * Dodaje do wiadomoci pocztowej wiadomo w HTML-u
     *
     * @param $html string Wiadomo w HTML-u.
     *
     * @return null
     */
    function html_data ($html) {
        $this->attachment("", $html, "text/html");
    }

    // }}}
    // {{{ plain_data()

    /**
     * Dodaje do wiadomoci pocztowej wiadomo w formie zwykego tekstu
     *
     * @param $data string Wiadomo w formie zwykego tekstu.
     *
     * @return null
     */
    function plain_data ($data) {
        $this->body = $data;
    }

    // }}}
}
?>