<?php
include_once("DB/standard.php");

function db_connect($args=array()) {
    array_shift($args);
    $conn = @ora_logon($args[0], $args[1]);
    $dbh = @ora_open($conn);
    return($dbh);
}

function db_pconnect($args=array()) {
    array_shift($args);
    $conn = @ora_plogon($args[0], $args[1]);
    $dbh = @ora_open($conn);
    return($dbh);
}

function db_db_query($args=array()) {
    return db_query($args);
}

function db_query($args=array()) {
    if (@ora_parse($args[0], $args[1]) < 0) {
        return(false);
    }
    @ora_exec($args[0]);
    return($args[0]);
}

function db_fetchrow($args=array()) {
    switch ($args[1]) {
        case DB_GETMODE_ASSOC:
            $cols = @ora_fetch_into($args[0], &$rows, ORA_FETCHINTO_ASSOC);
            break;
        case DB_GETMODE_NULL:
            $cols = @ora_fetch_into($args[0], &$rows, ORA_FETCHINTO_NULLS);
            break;
        default:
            $cols = @ora_fetch_into($args[0], &$rows);
            break;
    }
    if ($cols) {
        return($rows);
    }
    return(false);
}

function db_prepare($args=array()) {
    return db_simulate_prepare($args);
}

function db_execute($args=array()) {
    $stmt = db_simulate_execute(&$args);
    return db_fetchrow(array($stmt, array_shift($args)));
}


function db_num_rows($args=array()) {
    return @ora_numrows($args[0]);
}

function db_commit($args=array()) {
    return @ora_commit($args[0]);
}

function db_rollback($args=array()) {
    return @ora_rollbac($args[0]);
}

function db_autoCommit($args=array()) {
    return $args[1] ? @ora_commiton($args[0]) : @ora_commitoff($args[0]);
}

function db_free_result($args=array()) {
    return @ora_close($args[0]);
}

function db_close($args=array()) {
    return @ora_logoff($args[0]);
}
?>