<?php
//
// cart.php: plik gwny
//
require 'site_lib.inc';

session_register('cart'); // Rejestrujemy nasz sesj


// Inicjuj koszyk, jeli nie zosta jeszcze zainicjowany
if (!isset($cart[num_items])) {
    $cart = array("num_items" => 0, "products" => array());
}

// Zaaduj tablic $master_products_list z site_lib.inc
LoadProducts();
?>

<html>
<head>
    <title>Sklep z zabawkami Strelinga</title>
</head>

<body>

<h1>Witaj w sklepie z zabawkami Sterlinga</h1>

<?php
if ($cart[num_items]) { // Jeli jest co do pokazania
?>
<h2>Produkty znajdujce si w Twoim koszyku</h2>
<br>
<table border="2" cellpading="5" cellspacing="2">
<tr>
    <th>
        Nazwa produktu
    </th>
    <th>
        Krtki opis
    </th>
    <th>
        Cena
    </th>
    <th>
        Ilo
    </th>
    <th>
        &nbsp;
    </th>
</tr>
<?php
    // Przejd przez wszystkie produkty
    foreach ($cart[products] as $i => $product) {
        $product_id = $product[0];
        $quantity = $product[1];

        $total += $quantity * (double)$master_products_list[$product_id][price];
?>
<tr>
    <td>
        <?php echo $master_products_list[$product_id][name]; ?>
    </td>
    <td>
        <?php echo $master_products_list[$product_id][desc]; ?>
    </td>
    <td>
        <?php echo $master_products_list[$product_id][price]; ?>
    </td>
    <td>
        <form action="change_quant.php" method="GET">
        <input type="hidden" name="id" value="<?php echo $i; ?>">
        <input type="text" size="3" name="quantity" value="<?php echo $quantity; ?>">
    </td>
    <td>
        <input type="submit" value="Zmie ilo">
        </form>
    </td>
</tr>
<?php
    }
?>
<tr>
    <td colspan="2">
        <b>Razem: </b>
    </td>
    <td colspan="2">
        <?php echo $total; ?>PLN
    </td>
</tr>
</table>
<br>
<br>
<?php
}
?>

<h2>Zabawki dostpne w sklepie z zabawkami Sterlinga</h2>
<br>
<i>
    Mamy w ofercie nastpujce zabawki:
</i>
<br>
<table border="2" cellpadding="5" cellspacing="2">
<tr>
    <th>
        Nazwa produktu
    </th>
    <th>
        Opis produktu
    </th>
    <th>
        Cena
    </th>
    <th>
        &nbsp;
    </th>
</tr>
<?php
    // Poka wszystkie produkty
    foreach ($master_products_list as $product_id => $item) {
?>
<tr>
    <td>
        <?php echo $item[name]; ?>
    </td>
    <td>
        <?php echo $item[desc]; ?>
    </td>
    <td>
        <?php echo $item[price]; ?>PLN
    </td>
    <td>
        <a href="add_item.php?id=<?php echo $product_id; ?>">
            Dodaj ten produkt do koszyka
        </a>
    </td>
</tr>
<?php
    }
?>
</table>
</body>
</html>