<?php
//
// add_item.php:
//  Dodaje produkt do koszyka na zakupy
//
require 'site_lib.inc'; // LoadProducts()

LoadProducts(); // aduje produkty z $master_products_list

// Utwrz globaln tablic $curr_product
$curr_product = array();

// Przejd przez produkty i zatrzymaj si przy tym,
// ktry nas interesuje

foreach ($master_products_list as $prod_id => $product) {
    if (trim($prod_id) == trim($id)) {
        $curr_product = $product;
    }
}

// Zarejestruj sesj
session_register('cart');

if($ordered) { // Jeli zosta wybrany produkt
    array_push($cart[products], array(trim($id), $quantity));
    $cart[num_items] += $quantity;
}
?>

<html>
<head>
    <title>
    <?php if($ordered) { ?>
        Dodano <?php echo $curr_product[name]; ?> do koszyka na zakupy
    <?php } else { ?>
        Dodaj <?php echo $curr_product[name]; ?> do koszyka na zakupy
    <?php } ?>
    </title>
</head>
<body>
<?php if ($ordered) { ?>
    <h1><?php echo $curr_product[name]; ?>
        zosta dodany do koszyka na zakupy</h1>

    <a href="cart.php">Wr</a> i kontynuuj zakupy.
<?php } else { ?>
    <h1>Dodaj <?php echo $curr_product[name]; ?> do koszyka na zakupy</h1>

    <form action="<?php echo $PHP_SELF; ?>" method="GET">
    Nazwa produktu: <?php echo $curr_product[name]; ?>
    <br>
    Opis produktu: <?php echo $curr_product[desc]; ?>
    <br>
    Cena produktu: <?php echo $curr_product[price]; ?>
    <br>
    Ilo produktu: <input type="text" size="7" name="quantity">
    <input type="hidden" name="id" value="<?php echo $id; ?>">
    <input type="hidden" name="ordered" value="1">

    <input type="submit" value="Dodaj do koszyka">
    </form>

<?php } ?>
</body>
</html>