<?php
function start_element($parser, $element_name, $element_attr) {
    switch ($element_name) {
        case "RAMIONA":
        case "TWARZ":
            $data = ucfirst(strtolower($element_name));
            print "<h2>Deskryptor dla $data:</h2>\n<br>\n";
            break;

        case "BICEPSY":
        case "ROZMIAR":
        case "ZYLY":
        case "TRICEPSY":
        case "OCZY":
        case "USTA":
        case "WARGI":
        case "NOS":
        case "WLOSY":
            $data = ucfirst(strtolower($element_name));
            print "\n<br>\n$data";
            break;

        case "OBOLALE":
            print "\n<br>\nCzy sa obolale od cwiczen? ";
            break;
        case "KOLOR":
            print "\n<br>\nKolor moich oczu to: ";
            break;
    }
}

function end_element($parser, $element_name, $element_attr) {
    // puste
}

function character_data($parser, $data) {
    echo $data;
}

function pi_handler($parser, $type, $data) {
    if ($type == "php") {
        eval($data);
    }
}

function lost_data($parser, $data) {
    echo "<!-- Nie przetworzono danych (jako takich): $data -->\n";
}

function xml_conn($file) {
    $parser = xml_parser_create();
    xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 1);
    xml_set_element_handler($parser, "start_element", "end_element");
    xml_set_character_data_handler($parser, "character_data");
    xml_set_processing_instruction_handler($parser, "pi_handler");
    xml_set_default_handler($parser, "lost_data");
    xml_set_external_entity_ref_handler($parser, "external_ent_ref");
    if (!($fp = fopen($file, "r"))) {
        die("Nie mona otworzy pliku $file");
    }
    return array($fp, $parser);
}

function external_ent_ref($parser,
                          $open_ent_names,
                          $base,
                          $system_id,
                          $public_id) {
    if ($system_id != "") {
        list($fp, $parser) = xml_conn($system_id);
        while($data = fread($fp, 4096)) {
            print $data;
            xml_parse($parser, $data, feof($fp)) or
                die(sprintf('Bd XML: %s w linii %d.',
                    xml_error_string(xml_get_error_code($parser)),
                    xml_get_current_line_number($parser)));
        }
        xml_parser_free($parser);
        return true;
    }
    return false;
}

list($fp, $parser) = xml_conn('xmlref-test.xml');
while ($data = fread($fp, 4096)) {
    xml_parse($parser, $data, feof($fp))
        or die (sprintf('Bd XML: %s w linii %d.',
                xml_error_string(xml_get_error_code($parser)),
                xml_get_current_line_number($parser)));
}
xml_parser_free($parser);
?>