<?php
$validated = validate_credit_card ($credit_card_num, $cc_type);


function validate_credit_card ($cc_num, $cc_type='nieznany') {
    $cc_type = strtolower ($cc_type);
    $cc_num = ereg_replace ('[-[:space:]]',  '', $cc_num);

    switch ($cc_type)
    {
        case 'mastercard':
            if (strlen ($cc_num) != 16 || !ereg ('^5[1-5]', $cc_num)) {
                return false;
            }
            break;
        case 'visa':
            if (strlen ($cc_num) != 13 && (strlen ($cc_num) != 16 || $cc_num[0] != '4')) {
                return false;
            }
            break;
        case 'amex':
            if (strlen ($cc_num) != 15 || !ereg ('^3[47]', $cc_num)) {
                return false;
            }
            break;
        case 'discover':
            if (strlen ($cc_num) != 16 || substr ($cc_num, 0, 4) != '6011') {
                return false;
            }
            break;
        default:
            if ($cc_type != 'nieznany') return -1;
            break;
    }

    $digits = preg_split("//", $cc_num);
    $num_digits = count ($digits);

    for ($i = ($num_digits-2), $j = 0; $i >= 0; $i -= 2, $j++) {
        $double_digits[$j] = $digits[$i] * 2;
    }

    $validate = 0;
    for ($i = 0; $i < $num_digits; $i++) {
        $tmp_add = preg_split("//", $double_digits[$i]);
        for ($j = 0; $j < count ($tmp_add); $j++) {
            $validate += $tmp_add[$j];
        }
        unset($tmp_add);
    }

    for ($i = ($number_digits-1); $i >= 0; $i -= 2) {
        $validate += $digits[$i];
    }

    if (substr ($validate, -1, 1) == '0') { return true; }
    else { return false; }
}
?>