<?php
/*=====================================================================*\
    Funkcja:       debug_timing
    Przeznaczenie: Funkcja suca do testowania wydajnoci skryptu
    Wejcie:       $label - znacznik tekstowy wskazujcy punkt wykonania
                   'init' - inicjuje nowe uruchomienie
                   'print' - wywietla czas wykonania
\*=====================================================================*/
function debug_timing ($label) {
    static $basetime,
           $totaltime,
           $rpttimes;

    if ($label == 'init') {
        $rpttimes = array();
        $basetime = microtime();
        $totaltime = 0;
        ereg ("^([^ ]+) (.+)", $basetime, $r);
        $basetime = doubleval ($r[2]) + doubleval ($r[1]);

        return;
    }

    if ($label == 'print') {
        // wypisz na ekranie
        echo "<B>Czasy wykonania:</B><BR>\n";
        for ($i=0; $i < count ($rpttimes); $i++) {
            echo " $rpttimes[$i]<BR>\n";
        }
        echo "cznie: $totaltime\n";

        return;
    }

    // zapamitaj i dodaj czas trwania
    $newtime = microtime();
    ereg ("^([^ ]+) (.+)", $newtime, $r);
    $newtime = doubleval ($r[2]) + doubleval ($r[1]);

    $diff = $newtime - $basetime;
    $rpttimes[] = sprintf ("%-20s %s", $label, $diff);
    $basetime = $newtime;
    $totaltime += $diff;
}

?>