<?php
function html_options($output,
                      $values = NULL,
                      $selected = NULL,
                      $first_option_output = false)
{
    // Powrt, jeli nie ma nic do wywietlenia
    if (empty($output))
        return;

    // Rzutowanie wszystkich argumentw do tablic
    settype($values, "array");
    settype($output, "array");
    settype($selected, "array");

    // Znajd liczb wartoci w tablicach
    $num_output = count($output);
    $num_values = count($values);

    $html_output = "";

    if ($first_option_output) {
        $html_output = "<OPTION value=\"\">";
        $html_output .= "$first_option_output</OPTION>\n";
    }

    for ($i=0; $i < $num_output; $i++) {
        // Domylnie porwnaj warto z $selected
        $sel_check = $values[$i];
        $html_output .= "<OPTION";
        if ($i < $num_values) {
            $html_output .= " value=\"".$values[$i]."\"";
        } else {
            // Jeli w output jest wicej pozycji, ni w values,
            // porwnaj output z $selected.
            $sel_check = $output[$i];
        }

        if (in_array($sel_check, $selected)) {
            $html_output .= " selected";
        }
        $html_output .= ">".$output[$i]."</OPTION>\n";
    }

    return($html_output);
}
?>