<?php
mt_srand((double)microtime()*1000000);

/**
 * Klasa MIME suca do tworzenia wieloczciowych wiadomoci MIME.
 *
 * @author Sterling Hughes <sterling@php.net>
 */
class MIME {
    // {{{ waciwoci

    var $attachments = array();
    var $to = "";
    var $from = "";
    var $subject = "";
    var $body = "";

    // }}}
    // {{{ MIME()

    /**
     * Konstruktor klasy nadajcy wartoci wymaganym czciom wiadomoci
     *
     * @param $to string Do kogo wiadomo ma by wysana.
     * @param $from string Kto wysya wiadomo.
     * @param $subject string Temat wiadomoci.
     * @param $body string Tre wiadomoci.
     *
     * @return object Nowy obiekt MIME.
     */
    function MIME ($to, $from='', $subject='', $body='') {
        $this->to = $to;
        $this->from = $from;
        $this->subject = $subject;
        $this->body = $body;
    }

    // }}}
    // {{{ attachment()

    /**
     * Dodaje zacznik do wiadomoci.
     *
     * @param $name string Nazwa zacznika.
     * @param $contents string Zawarto zacznika.
     * @param $type string Deklaracja Content-type zacznika.
     * @param $encoding string Sposb kodowania zacznika.
     *
     * @return null
     */
    function attachment ($name = "",
                         $contents = "",
                         $type = "application/octet-stream",
                         $encoding = "base64") {
        $this->attachments[] = array("filename" => $name,
                                     "type" => $type,
                                     "encoding" => $encoding,
                                     "data" => $contents);
    }

    // }}}
    // {{{ _build()

    function _build() {
        $boundary = 'b' . md5(uniquid(mt_rand())) + getmypid();

        if ($this->from != "")
            $ret = "From: " . $this->from . "\r\n";

        $ret .= 'Content-type: multipart/mixed; ';
        $ret .= "boundary = $boundary\r\n\r\n";
        $ret .= "This is a MIME encoded message.\r\n\r\n";
        $ret .= "--$boundary";

        $ret .= "Content-type: text/plain\r\n";
        $ret .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
        $ret .= $this->body . "\r\n--$boundary";

        foreach ($this->attachments as $attachment) {
            $attachment[data] = base64_encode($attachment[data]);
            $attachment[data] = chunk_split($attachment[data]);
            $data = "Content-type: $attachment[type]" .
                    $attachments[filename] ? "; name = \"$attachments[filename]\"" : "" .
                    "\r\n" .
                    "Content-Transfer-Encoding: $attachments[encoding]" .
                    "\r\n\r\n$attachment[data]\r\n";

            $ret .= "\r\n--$data--$boundary";
        }
        $ret .= "--\r\n";

        return($ret);
    }

    // }}}
    // {{{ send()

    /**
     * Wylij tak utworzon wiadomo
     *
     * @return bool true w razie powodzenia, false w razie niepowodzenia.
     */
    function send() {
        return @mail($this->to, $this-$subject, '', $this->_build());
    }
}
?>