<?php
//
// site_lib.inc -->
// Zawiera funkcj LoadProducts().
//

// Tablica globalna ze wszystkimi produktami
// Lista $master_products_list wypeniana przez funkcj LoadProducts().
$master_products_list = array();

//
// void LoadProducts(void)
//   aduje wszystkie produkty, jakie mog znale si w koszyku,
//   do globalnej tablicy $master_products_list.
//
function LoadProducts() {
    global $master_products_list;
    $filename = 'products.txt';

    $fp = @fopen($filename, "r") or die("Nie mona otworzy $filename");

    // Na wszelki wypadek nakadamy blokad wspuytkowan;
    // miaaby znaczenie, gdybymy rwnie zapisywali do tego pliku.
    @flock($fp, 1) or die("Nie mona naoy blokady wspuytkowanej na $filename");

    while ($line = fgets($fp, 1024)) {
        list($id, $name, $desc, $price) = explode('|', $line);
        $id = trim($id); // obetnij niepotrzebne znaki
        $master_products_list[$id] = array("name" => $name,
                                           "desc" => $desc,
                                           "price" => $price);
    }

@fclose($fp) or die("Nie mona zamkn $filename");
}
?>