<?php
//
// schemat tabeli 'sessions'
// create table sessions (
//   session_id char(32) not null,
//   session_data text not null,
//   session_expiration int(11) unsigned not null,
//   primary key (session_id));
//

include_once 'DB.php';

// Zmienne globalne
$dbh = NULL;

function on_session_start ($save_path, $session_name) {
    global $dbh;

    $dbh = DB::connect('mysql://user:secret@localhost/SITE_SESSIONS', true);

    if (DB::isError($dbh)) {
        die(sprintf('Bd [%d]: %s', $dbh->getCode(), $dbh->getMessage()));
    }
}

function on_session_end ()
{
    // Ta funkcja nie musi nic robi,
    // bo uylimy poczenia staego
}

function on_session_read ($key)
{
    global $dbh;

    $stmt = "select session_data from sessions";
    $stmt .= " where session_id = '$key'";
    $stmt .= " and session_expiration > now()";

    $sth = $dbh->query($sth);
    $row = $sth->fetchRow(DB_FETCHMODE_ASSOC);
    return $row['session_data'];
}

function on_session_write ($key, $val)
{
    global $dbh;

    $val = addslashes($val);

    $insert_stmt = "insert into sessions values('$key', '$val', now() + 3600)";
    $update_stmt = "update sessions set session_data = '$val', ";
    $update_stmt .= "session_expiration = now() + 3600 ";
    $update_stmt .= "where session_id = '$key'";

    // Najpierw prbujemy polecenia insert; jeli nie zadziaa, oznacza to,
    // e sesja jest ju zapisana w tabeli i trzeba j uaktualni
    if (DB::isError($dbh->query($insert_stmt)))
        $dbh->query($update_stmt);
}

function on_session_destroy ($key)
{
    global $dbh;

    $stmt = "delete from sessions where session_id = '$key'";
    $dbh->query($stmt);
}

function on_session_gc ($max_lifetime)
{
    global $dbh;

    // W tym przykadzie nie bdziemy stosowa parametru $max_lifetime
    // Po prostu usuniemy wszystkie sesje, ktre wygasy
    $stmt = "delete from sessions where session_expiration < now()";
    $dbh->query($stmt);
}

session_start();

// Zarejestruj zmienn $counter jako cz sesji
session_register("counter");

// Wska funkcje przechowywania sesji
session_set_save_handler ("on_session_start",   "on_session_end",
                          "on_session_read",    "on_session_write",
                          "on_session_destroy", "on_session_gc");

// Sprawdmy, co si stanie
$counter++;

print $counter;

session_destroy();

?>