<?php
//file_info.php

function date_str($timestamp) {
   $date_str = getdate($timestamp);
   $year = $date_str["year"];
   $mon = $date_str["mon"];
   $mday = $date_str["mday"];
   $hours = $date_str["hours"];
   $minutes = $date_str["minutes"];
   $seconds = $date_str["seconds"];
   
   return "$hours:$minutes:$seconds $mday/$mon/$year";
}

function file_info($file) {
   global $WINDIR;

   $file_info_array["wielkosc"] = 
                  number_format(filesize($file)) . " bajtw.";
   $file_info_array["data ostatniej zmiany"] = date_str(filectime($file));
   $file_info_array["data ostatniej modyfikacji"] = date_str(filemtime($file));

   if(!isset($WINDIR)) {
      $file_info_array["data ostatniego dostpu"] = date_str(fileatime($file));
      $file_info_array["grupa"] = filegroup($file);
      $file_info_array["waciciel"] = fileowner($file);
   }
   $file_info_array["typ"] = filetype($file);

   return $file_info_array;
}

$filename = "./count.dat";
$file_info_array = file_info($filename);

echo "<center>Statystyka $filename</center>";
foreach($file_info_array as $key=>$val) {
   echo ucfirst($key) . "=>". $val . "<br>";
}
?>
