<?php
if( ! ($fp = fopen("http://freshmeat.net/backend/fm.rdf" , "r" )) )
  die("Nie mona otworzy pliku XML!");
$item_counter = 0;
$in_item_tag = 0;
$fm_current_tag_state = '';
$fm_headline_data = array();

function startElementHandler($parser, $element_name, $element_attribs)
{
  global $item_counter;
  global $in_item_tag;
  global $fm_current_tag_state;
  global $fm_headline_data;
  if( $element_name == "ITEM" )
  {
    $in_item_tag = 1;
  }
  if( $in_item_tag == 1 )
  {
    $fm_current_tag_state = $element_name;
  }
  else
  {
    $fm_current_tag_state = '';
  }
}

function endElementHandler( $parser, $element_name )
{
  global $item_counter;
  global $in_item_tag;
  global $fm_current_tag_state;
  global $fm_headline_data;
  $fm_current_tag_state = '';
  if( $element_name == "ITEM" )
  {
    $item_counter++;
    $in_item_tag = 0;
  }
}
function characterDataHandler( $parser , $data )
{
  global $item_counter;
  global $in_item_tag;
  global $fm_current_tag_state;
  global $fm_headline_data;
  if( $fm_current_tag_state == '' || $in_item_tag == 0 )
    return;
  if( $fm_current_tag_state == "TITLE" ) {
    $fm_headline_data[$item_counter]["title"] = $data;
  }
  if( $fm_current_tag_state == "LINK" ) {
    $fm_headline_data[$item_counter]["link"] = $data;
  }
  if( $fm_current_tag_state == "DESCRIPTION" ) {
    $fm_headline_data[$item_counter]["description"] = $data;
  }
}
if( !($xml_parser = xml_parser_create()) )
  die("Nie mona utworzy parsera XML!");

xml_set_element_handler($xml_parser, "startElementHandler", "endElementHandler");
xml_set_character_data_handler( $xml_parser , "characterDataHandler" );
while( $data = fread($fp, 4096) )
{
  if( !xml_parse($xml_parser, $data, feof($fp)) )
  {
    break; // jeli przetwarzanie pliku zostao zakoczone, wychodzimy z ptli
  }
}
xml_parser_free($xml_parser);
?>
<HTML>
<HEAD>
<TITLE>Analiza pliku RDF z witryny Freshmeat</TITLE>
</HEAD>

<BODY BGCOLOR="#ffffff">

<H3>Nagwki</H3>
<BR>
<?php

for( $i=0 ; $i < $item_counter ; ++$i )
{
  printf("<A HREF=\"%s\">%s</a> - %s<br>\n" , $fm_headline_data[$i]["link"] ,
                                              $fm_headline_data[$i]["title"] ,
                                              $fm_headline_data[$i]["description"] );
}

?>

</BODY>
</HTML>
