<?php
if( ! ($fp = fopen( "./lotr_z_dtd.xml" , "r" )) )
  die("Nie mona otworzy pliku XML!");
$person_counter = 0;
$person_data = array();
$xml_current_tag_state = '';
function startElementHandler( $parser, $element_name, $element_attribs )
{
  global $person_counter;
  global $person_data;
  global $xml_current_tag_state;
  if( $element_name == "PERSON" )
  {
    $person_data[$person_counter]["alignment"] = $element_attribs["ALIGNMENT"];
  }
  else
  {
    $xml_current_tag_state = $element_name;
  }
}
function endElementHandler( $parser, $element_name )
{
  global $person_counter;
  global $person_data;
  global $xml_current_tag_state;
  $xml_current_tag_state = '';
  if( $element_name == "PERSON" )
  {
    $person_counter++;
  }
}
function characterDataHandler( $parser , $data )
{
  global $person_counter;
  global $person_data;
  global $xml_current_tag_state;
  if( $xml_current_tag_state == '' )
    return;
  if( $xml_current_tag_state == "NAME" ) {
    $person_data[$person_counter]["name"] = $data;
  }
  if( $xml_current_tag_state == "RACE" ) {
    $person_data[$person_counter]["race"] = $data;
  }
  if( $xml_current_tag_state == "HOME" ) {
    $person_data[$person_counter]["home"] = $data;
  }
}
if( !($xml_parser = xml_parser_create()) )
  die("Nie mona utworzy analizatora XML!");

xml_set_element_handler($xml_parser, "startElementHandler", "endElementHandler");
xml_set_character_data_handler($xml_parser, "characterDataHandler");
while( $data = fread($fp, 4096) )
{
  if( !xml_parse($xml_parser, $data, feof($fp)) )
  {
    break; // jeli przetwarzanie pliku zostao zakoczone, wychodzimy z ptli
  }
}
xml_parser_free($xml_parser);
?>

<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">
<HTML>
<HEAD>
  <TITLE>Przetwarzanie przykadowego pliku XML</TITLE>
</HEAD>

<BODY BGCOLOR="#ffffff">

<?php
for( $i=0 ; $i < $person_counter ; ++$i )
{
  $font_color = $person_data[$i]["alignment"] == "dobry" ? "#0000ff" : "#ff0000";

  echo "<FONT SIZE=\"+1\" color=\"$font_color\">" .
           $person_data[$i]["name"] . "</FONT><BR>\n";
  echo "Rasa: &nbsp;&nbsp;" . $person_data[$i]["race"] . "<BR>\n";
  echo "Miejsce zamieszkania: &nbsp;&nbsp;" . $person_data[$i]["home"] . "<BR>\n";
  echo "<BR>\n";
}

?>

</BODY>
</HTML>
