<?php

/*
    MWeather v0.5.2 - A weather script written in PHP
    Copyright (C) 2000 Matt Wilson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
error_reporting( E_ALL & ~E_NOTICE );
echo "<!-- MWeather v0.5.1 by Matt Wilson <matt@mattsscripts.co.uk>-->";

require( "config.php" );

// just make sure =D
$region = strtoupper($region);

// just in case we're only running php3
function array_myshift(&$a)
{
	if(!sizeof($a))
		return false;

	$c = trim($a[0]);
	for($t=1; $t<sizeof($a); $t++)
		$b[] = $a[$t];

	$a = $b;

	return $c;
}

if(($metar_ = @file("ftp://weather.noaa.gov/data/observations/metar/stations/$region.TXT")) == false){
	echo "\n<!--- unable to find metar data --->\n";
	require $noweather;
	exit();
}

if(($tmpl = @file($template_main, True)) == false){ // BRS
	require $noweather;
	exit();
}

function strip_blank($e)
{
	$ar = explode(" ",$e);
	$t_ = array();
	for($t=0; $t<sizeof($ar); $t++)
		if(strlen($ar[$t]))
			$t_[] = $ar[$t];

	return $t_;
}

function temp_image($temp)
{
	global $sun_vhot;
	global $sun_hot;
	global $sun_med;
	global $sun_low;
	global $sun_vlow;
	global $sun_vvlow;

	if($temp > 40)
		return $sun_vhot;
	
	if($temp > 30)
        	return $sun_hot;
	
	if($temp > 20)
        	return $sun_med;
	
	if($temp > 10)
        	return $sun_low;
	
	if($temp > 0)
        	return $sun_vlow;
	
	return $sun_vvlow;
}

function return_wind_dir($wind_dir)
{
	if(348 < $wind_dir || $wind_dir <= 11)
        	return "North";

	if(11 < $wind_dir && $wind_dir <= 33)
	        return "North North East";

	if(33 < $wind_dir && $wind_dir <= 57)
	        return "North East";

	if(57 < $wind_dir && $wind_dir <= 78)
	        return  "East North East";

	if(78 < $wind_dir && $wind_dir <= 102)
	        return "East";

	if(102 < $wind_dir && $wind_dir <= 123)
	        return "East South East";

	if(123 < $wind_dir && $wind_dir <= 157)
	        return "South East";

	if(157 < $wind_dir && $wind_dir <= 168)
	        return "South South East";

	if(168 < $wind_dir && $wind_dir <= 192)
	        return "South";

	if(192 < $wind_dir && $wind_dir <= 213)
		return "South South West";

	if(213 < $wind_dir && $wind_dir <= 237)
        	return "South West";

	if(237 < $wind_dir && $wind_dir <= 258)
        	return "West South West";

	if(258 < $wind_dir && $wind_dir <= 282)
        	return "West";

	if(282 < $wind_dir && $wind_dir <= 303)
        	return "West North West";

	if(303 < $wind_dir && $wind_dir <= 327)
		return"North West";

	if(327 < $wind_dir && $wind_dir <= 348)
        	return "North North West";

	return "?Unknown?";
}

function getareaname()
{
	global $region;

	if(($codes = @file("CODES", True)) == false) // BRS
		return "Unknown";

	for($tmp=0; $tmp<count($codes); $tmp++){ // changed, BRS
		$_o = strpos($codes[$tmp],$region);
		if($_o === False) // changed for PHP4, BRS
			continue;

		return trim(substr($codes[$tmp],$_o+8));
	}

	return "Unknown";
}

function do_drop_down()
{
	global $use_dropdown_menus;
	global $dropdown_area;

	$dropdown_area_ = strtolower($dropdown_area);

	if(!$use_dropdown_menus)
		return "<!--- drop down turned off --->";

	if(($codes = @file("dropdown.cfg", True)) == false) // BRS
		return "<!--- dropdown.cfg file not found --->";

	for($tmp=0; $tmp<sizeof($codes); $tmp++){
		$fc = substr($codes[$tmp],0,1);
		if($fc == "-"){
			$code = substr($codes[$tmp],1,strlen($codes[$tmp])-2);
			if(trim(strtolower($code)) == trim($dropdown_area_))
				break;
		}
	}

	if(strtolower($code) != $dropdown_area_)
		return "<!--- drop down region un-supported --->";

	$formcode = "<form action=mweather.php3 method=post>\n<select name=region>\n";

	$tmp++;
	while(substr($codes[$tmp],0,1) != "+"){
		$stuff = explode(" -> ",$codes[$tmp]);
		$formcode = $formcode."<option value=".trim($stuff[0]).">".$stuff[1]."</option>\n";
		$tmp++;
	}

	$formcode = $formcode."</select><input type=hidden name=dropdown_area value=\"$dropdown_area\"><input type=submit value=\"Go!\"></form>";

	return $formcode;
}

function updatedt($date, $month, $year, $time, &$ndate, &$ntime)
{
        global $date_format;
	global $time_format;

        $_t = explode(":",$time);
        $ndate = date($date_format,mktime($_t[0], $_t[1], 0, $month, $date, $year));
	$ntime = date($time_format,mktime($_t[0], $_t[1], 0, $month, $date, $year));
}

if(!isset($area_name) || !strlen($area_name))
	$area_name = getareaname();

$tmpl = implode("",$tmpl);

for($t=0; $t<sizeof($metar_); $t++)
	$metar_[$t] = trim(str_replace("\n","",$metar_[$t]));

$metar = implode(" ",strip_blank(implode(" ",$metar_)));

$cloud_types = array(
	"SCT" => "Scattered",
	"FEW" => "Few",
	"SKC" => "No&nbsp;clouds",
	"BKN" => "Broken",
	"OVC" => "Overcast",
	"CLR" => "Clear"
);
$cloud_images = array(
	"OVC" => $clouds_lots,
	"FEW" => $clouds_few,
	"SCT" => $clouds_med,
	"SKC" => $clear_sky,
	"BKN" => $clouds
);
$precip_types = array(
	"DZ" => "Drizzle",
	"RA" => "Rain",
	"SN" => "Snow",
	"SG" => "Snow grains",
	"IC" => "Ice cystals",
	"PL" => "Ice pellets",
	"GR" => "Hail",
	"GS" => "Small hail/snow pellets",
	"UP" => "Unknown",
	"BR" => "Mist",
	"FG" => "Fog",
	"FU" => "Smoke",
	"VA" => "Volcanic Ash",
	"SA" => "Sand",
	"HZ" => "Haze",
	"PY" => "Spray",
	"DU" => "Widespread Dust",
	"SQ" => "Squal",
	"SS" => "Sandstorm",
	"DS" => "Duststorm",
	"PO" => "Well developed dust/sand whirls",
	"FC" => "Funnel cloud",
	"MI" => "Shallow",
	"BC" => "Patches",
	"PR" => "Partial",
	"TS" => "Thunderstorm",
	"BL" => "Blowing",
	"SH" => "Showers",
	"DR" => "Drifting",
	"FZ" => "Freezing"
);
$precip_images = array(
        "DZ" => $drizzle,
        "RA" => $rain,
        "SN" => $snow,
        "SG" => $snow_grains,
        "IC" => $ice_crystals,
        "PL" => $ice_pellets,
        "GR" => $hail,
        "GS" => $hail_small,
        "UP" => $unknown,
        "BR" => $mist,
        "FG" => $fog,
        "FU" => $smoke,
        "VA" => $volcanic_ash,
        "SA" => $sand,
        "HZ" => $haze,
        "PY" => $spray,
        "DU" => $widespread_dust,
        "SQ" => $squal,
        "SS" => $sandstorm,
        "DS" => $duststorm,
        "PO" => $dust_or_sand_whirls,
        "FC" => $funnel_cloud,
        "TS" => $thunderstorm,
        "SH" => $showers,
        "FZ" => $freezing
);
$precip_intensities = array(
	"none at all",
	"v v light",
	"v light",
	"light",
	"light-ish",
	"medium",
	"heavy-ish",
	"heavy",
	"v heavy",
	"v v heavy"
);

echo "<!-- metar codes = `$metar' -->\n";
$options = explode(" ",$metar);
$____ = explode("/",array_myshift($options));
$year = $____[0];
$month = $____[1];
$date = $____[2];
$time = array_myshift($options);

$_ = array_myshift($options);
if($_ != $region){	// the region, indicating an error in the data file
	echo "\n<!-- crashed checking region - reported as `$_' -->\n";
//	require $noweather;
//	exit();
}

// another indication of an error in the data file
$check = array_myshift($options);
if($check != $date.str_replace(":","",$time)."Z"){
	echo "\n<!-- crashed checking date/time - reported as $check -->\n";
//	require $noweather;
//	exit();
}

settype($year,"integer");
settype($month,"integer");
settype($date,"integer");

// the loop to identify all options

while(($_op = array_myshift($options)) != false){

	if(!strlen($_op))
		continue;

	if(substr($_op,-2) == "KT"){
		$wind_dir = substr($_op,0,3)%360;
		settype($wind_dir,"integer");
		$wind_speed = substr($_op,3,2);
		settype($wind_speed,"integer");
		$wind_units = substr($_op,5,2);
	}

// cloud info?
	$_ = substr($_op,0,3);

        if($_ == "SCT" || $_ == "FEW" || $_ == "SKC" || $_ == "BKN" || $_ == "OVC" || $_ == "CLR"){
		$cloud_type[] = $_;
		if($_ == "CLR")
			$cloud_height[] = 12000;
		else{
	                $cloud_height[] = substr($_op,3,3);
			settype($cloud_height[sizeof($cloud_height)-1],"integer");
			$cloud_height[sizeof($cloud_height)-1] *= 100;
		}
		$cloud_height_metar[] = $cloud_height[sizeof($cloud_height)-1]/3.281027104;
		continue;
        }

// temperature info? - no point in doing it twice
	if($dealt_with_temperature == false){
		if(substr($_,-1,1) == "/"){
			$dealt_with_temperature = true;
			$temp = substr($_op,0,2);
			@settype($temp,"integer");
			$temp_dewpoint = substr($_op,3,2);
			@settype($temp_dewpoint,"integer");
                        $temp_f = @round(($temp*9/5)+32);
                        $temp_dewpoint_f = ($temp_dewpoint*9/5)+32;
                        $humidity = @round(($temp_dewpoint/$temp)*100);
			continue;
		}
	}

// precipitation info - prolly gonna be very buggy, will redo at some point =D
	$dlen = strlen($_op);
// precip intensity info
	if(ereg("^([0-9]){4}$",$dlen)){
		if(strlen($options[0]) < 6){
			$_op2 = array_myshift($options);
			$dlen = strlen($_op2);
			$precip[] = substr($_op2,($dlen%2),2);
			$precip_intensity[] = substr($_op,sizeof($precip)-1,1);
			if($dlen > 3)
				$precip_descrip[] = substr($_op2,2+($dlen%2),2);
			else
				$precip_descrip[] = "";
			continue;
		}
	}
}

// determine which pictures to use  

$img_temp = temp_image($temp);

for($l=0; $l<sizeof($cloud_type); $l++){
	if($cloud_type[$l] == "OVC"){
		$cloud_img = "OVC";
		break;
	}
	elseif($cloud_type[$l] == "BKN" && $cloud_img != "OVC")
		$cloud_img = "BKN";
	elseif($cloud_type[$l] == "SCT" && $cloud_img != "OVC" && $cloud_img != "BKN")
		$cloud_img = "SCT";
	elseif($cloud_type[$l] == "FEW" && $cloud_img != "OVC" && $cloud_img != "BKN" && $cloud_img != "SCT")
		$cloud_img = "FEW";
	else
		$cloud_img = "SKC";
}

if($use_head_and_foot_templates)
	require $template_header;

$wind_dir_ = return_wind_dir($wind_dir);

if(sizeof($cloud_type)){
	for($l=0; $l<sizeof($cloud_type); $l++)
		$cloud_info = sprintf("%s%s&nbsp;@&nbsp;%d&nbsp;feet&nbsp(%d&nbsp;metar)<br>",$cloud_info,$cloud_types[$cloud_type[$l]],$cloud_height[$l],$cloud_height_metar[$l]);
}
else{
	$cloud_img = $unknown;
	$cloud_info = "Unknown";
}
if(sizeof($precip)){
	for($l=0; $l<sizeof($precip); $l++){
//		$precip_info = sprintf("%s%s&nbsp;(%s",$precip_info,$precip_types[$precip[$l]],$precip_intensities[$precip_intensity[$l]]);
              	$precip_info = sprintf("%s%s",$precip_info,$precip_types[$precip[$l]]);
		if(strlen($precip_descrip[$l]))
			$precip_info = sprintf("%s&nbsp;(%s)",$precip_info,$precip_types[$precip_descrip[$l]]);

//		$precip_info = sprintf("%s)<br>",$precip_info);
		$precip_info = sprintf("%s<br>",$precip_info);
	}
	$precip_img = $precip_images[$precip[0]];
}
else{
	$precip_info = "None";
	$precip_img = $clear_sky;
}

updatedt($date,$month,$year,$time, $ndate, $ntime);

$tmpl = str_replace("[>AREA_NAME<]",$area_name,$tmpl);
$tmpl = str_replace("[>FDATE<]",$ndate,$tmpl);
$tmpl = str_replace("[>TIME<]",$ntime,$tmpl);
$tmpl = str_replace("[>TEMP_C<]",$temp,$tmpl);
$tmpl = str_replace("[>TEMP_F<]",$temp_f,$tmpl);
$tmpl = str_replace("[>HUMIDITY<]",$humidity,$tmpl);
$tmpl = str_replace("[>TEMP_IMG<]",$img_temp,$tmpl);
$tmpl = str_replace("[>WIND_DIR<]",$wind_dir_,$tmpl);
$tmpl = str_replace("[>WIND_DEG<]",$wind_dir,$tmpl);
$tmpl = str_replace("[>WIND_SPEED<]",$wind_speed,$tmpl);
$tmpl = str_replace("[>CLOUD_INFO<]",$cloud_info,$tmpl);
$tmpl = str_replace("[>CLOUD_IMG<]",$cloud_images[$cloud_img],$tmpl);
$tmpl = str_replace("[>PRECIP_INFO<]",$precip_info,$tmpl);
$tmpl = str_replace("[>PRECIP_IMG<]",$precip_img,$tmpl);
$tmpl = str_replace("[>REGION_DD<]",do_drop_down(),$tmpl);

// show the template
echo $tmpl;

if($use_head_and_foot_templates)
	require $template_footer;
?>
