CREATE TABLE mcMerchants
(
    merchant_id     int                         not null,
    name            varchar(50)                 not null,
    created_date    datetime                    not null,
    internal_status int                         not null,
    addtl_handling  float           default 0.0 not null,
    mgr_email       varchar(25)                 not null,
    mgr_username    varchar(30)                 not null,
    mgr_password    varchar(30)                 not null,
    mgr_name        varchar(50)                 not null,
    
    primary key ( merchant_id ),
    index( name ),
    index( mgr_username )
);

CREATE TABLE mcCategories
(
    merchant_id     int                         not null,
    category_id     int                         not null,
    name            varchar(50)                 not null,
    created_date    datetime                    not null,
    deleted         tinyint         default 0   not null,
    
    primary key ( merchant_id, category_id ),
    index( name )
);

CREATE TABLE mcProducts
(
    merchant_id     int                         not null,
    product_id      int                         not null,
    category_id     int                         not null,
    name            varchar(200)                not null,
    descr           text                        not null,
    has_image_file  tinyint     default 0       not null,
    external_id     varchar(100)                not null,
    ship_weight     float                       not null,
    price           float                       not null,
    created_date    datetime                    not null,
    deleted         tinyint     default 0       not null,
    
    primary key ( merchant_id, product_id ),
    index( name )
);

CREATE TABLE mcProductsToCategories
(
    merchant_id     int                         not null,
    category_id     int                         not null,
    product_id      int                         not null,
    
    primary key ( merchant_id, category_id, product_id )
);

CREATE TABLE mcProductsOptions
(
    merchant_id     int                         not null,
    product_id      int                         not null,
    option_id       int                         not null,
    name            varchar(100)                not null,
    sort_type       tinyint     default 0       not null,
        
    primary key ( merchant_id, product_id, option_id ),
    index( name )
);

CREATE TABLE mcProductsOptionsValues
(
    merchant_id     int                         not null,
    product_id      int                         not null,
    option_id       int                         not null,
    value_id        int                         not null,
    name            varchar(100)                not null,
        
    primary key ( merchant_id, product_id, option_id, value_id ),
    index( name )
);


