<?php
/*
   _fin_mpmt:
   oblicza miesiczn spat kredytu w oparciu o
   kwot kredytu (p), oprocentowanie (i) oraz czas (l)
*/
function fin_mpmt ( $p, $i, $l)
{
  $j = $i / (12 * 100);
 $n = $l * 12;
  return ( $p* ( $j/( 1 - (pow(( 1+$j ), ($n * -1))))));
}
/*
  _fin_total:
  oblicza cakowit kwot spat w czasie trwania kredytu
  w oparciu o kwote kredytu (p), oprocentowanie (i) i czas (l)
*/
function fin_total ( $p, $i, $l)
{
  return fin_mpmt( $p, $i, $l) * $l * 12;
}
/*
  _fin_table:
  oblicza miesiczne odsetki uywane w planie amortyzacji dla kredytw
  w oparciu o kwot (p), oprocentowanie (i), i czas (l)
*/
function fin_table ( $p, $i, $l)
{
  $j = $i / (12 * 100);
  $n = $l * 12;
  $q = $p;
  $m = fin_mpmt( $p, $i, $l );
  for ($nIndex = 0; $nIndex < $n; $nIndex++ )
  {
    $h = $q * $j;
    $c = $m - $h;
    $q = $q - $c;
    $pIntPmt[$nIndex] = $h;
  }
  return $pIntPmt;
}
?>