<?php
function pi_approx_bc( $iterations, $print_frequency, $scale)
{
  $squared_approx = "12";
  $next_sign = -1;
  $denom = 2;

  for ($iter = 0; $iter < $iterations; $iter++)
  {
    $squared_approx = 
      bcadd( $squared_approx, 
             bcmul($next_sign, 
	           bcdiv(12,
		         bcpow($denom, 
			       2,
			       $scale),
			 $scale),
	           $scale),
	     $scale);
    $denom++;
    $next_sign = -$next_sign;
    if ($denom % $print_frequency == 0)
    {
      $estimate = bcsqrt($squared_approx, $scale);
      print( "$denom iteracja: $estimate<BR>");
    }
  }
}

pi_approx_bc(125000, 5000, 50);
?>