<?php
/* Cz 1 - algorytm szyfrowania i funkcje usugowe*/ 
function add_1 ($num)
{ 
  return(($num + 1) % 26); 
}

function sub_1 ($num) 
{
  return(($num + 25) % 26); 
}

function swap_2 ($num) 
{
  if ($num % 2 == 0) 
    return($num + 1); 
  else
    return($num - 1); 
}

function swap_26 ($num) 
{
  return(25 - $num); 
}

function lower_letter($char_string) 
{
  return ((ord($char_string) >= ord('a')) && 
          (ord($char_string) <= ord('z'))); 
}

function upper_letter($char_string) 
{
  return ((ord($char_string) >= ord('A')) && 
          (ord($char_string) <= ord('Z'))); 
}

/* Cz 2 - funkcje szyfrowania liter*/ 
function letter_cipher ($char_string, $code_func) 
{
  if (!(upper_letter($char_string) || 
        lower_letter($char_string))) 
    return($char_string);
  if (upper_letter($char_string)) 
    $base_num = ord('A');
  else 
    $base_num = ord('a'); 
	
  $char_num = ord($char_string) - $base_num;
  return(chr($base_num + ($code_func($char_num) % 26)));
}

/* Cz 3 - gwna funkcja szyfrowania cigu */ 
function string_cipher($message, $cipher_func) 
{
  $coded_message = ""; 
  $message_length = strlen($message); 
  for ($index = 0;
       $index < $message_length; 
       $index++)
    $coded_message .=
      letter_cipher($message[$index], $cipher_func); 
  return($coded_message);
}
$original = "Zaszyfrowany komunikat to ABCDEFG"; 
print("Cig oryginalny to: $original<BR>"); 
$coding_array = array('add_1',
                      'sub_1', 
                      'swap_2', 
                      'swap_26'); 
  for ($count = 0;
      $count < sizeof($coding_array); 
      $count++)
  { 
    $code = $coding_array[$count]; 
    $coded_message =
      string_cipher($original, $code); 
    print("Zakodowane $code to: $coded_message<BR>"); 
}

function chained_code ($message) 
{
  /* Pobiera cig oraz dowoln liczb nazw funkcji kodujcych 
  zwraca wynik zastosowania na cigu wszystkich metod */
  
  $argc = func_num_args();
  $coded = $message;
  for ($count = 1; $count < $argc; $count++) 
  {
    $function_name = func_get_arg($count); 
    $coded = string_cipher($coded, $function_name); 
  }
  return($coded);
}


$tricky =
  chained_code($original,
               'add_1', 'swap_26',
               'add_1', 'swap_2');
print("Zakodowana wersja to $tricky<BR>");
$easy =
  chained_code($original,
               'add_1', 'swap_26',
               'swap_2', 'sub_1',
               'add_1', 'swap_2',
               'swap_26', 'sub_1');
print("Zakodowana wersja to $easy<BR>");

