<?php # Listing 12.15 - view_users.php
// Skrypt umoliwia administratorowi przegldanie listy aktualnie zalogowanych uytkownikw.

// Doczenie pliku konfiguracyjnego obsugujcego bdy, itp.
require_once ('../includes/config.inc'); 

// Wymuszenie przeprowadzenia autoryzacji.
require_once ('../../authentication.php');

// Okrelenie tytuu strony i doczenie nagwka HTML.
$page_title = 'Lista aktualnie zalogowanych uytkownikw';
include_once ('../includes/admin_header.html');

// Sprawdzenie czy przeprowadzono autoryzacj.
if (!$authorized) {
	echo '<p><font color="red" size="+1">Prosz poda poprawn nazw uytkownika i haso! Kliknij <a href="index.php">tutaj</a>, aby sprbowa ponownie!</font></p>';
} else {

	require_once ('../../mysql_connect.php'); // Poczenie z baz danych.

	// Okrelenie liczby rekordw wywietlanych na jednej stronie:
	$display = 10;
	
	// Okrelenie liczby stron. 
	if (isset($_GET['np'])) { // Jeli ju okrelono liczb stron.
		$num_pages = $_GET['np'];
	} else { // Jeli jeszcze nie okrelono.
		$query = "SELECT CONCAT(last_name, ', ', first_name) AS name, DATE_FORMAT(registration_date, '%M %d, %Y') AS dr FROM users ORDER BY registration_date ASC"; 
// Standardowe zapytanie.
		$query_result = mysql_query ($query);
		$num_records = @mysql_num_rows ($query_result);
		
		if ($num_records > $display) { // Wicej ni jedna strona.
			$num_pages = ceil ($num_records/$display);
		} else {
			$num_pages = 1;
		}
	}
	
	// Okrelenie w bazie danych miejsca, od ktrego rozpocznie si zwracanie wynikw.
	if (isset($_GET['s'])) { // Jeli miejsce ju okrelono.
		$start = $_GET['s'];
	} else {
		$start = 0;
	}
			
	// Wykonanie zapytania.
	$query = "SELECT CONCAT(last_name, ', ', first_name) AS name, DATE_FORMAT(registration_date, '%M %d, %Y') AS dr FROM users ORDER BY registration_date ASC LIMIT $start, $display";		
	$result = @mysql_query ($query); // Wykonanie zapytania.
	$num = mysql_num_rows ($result); // Ilu istnieje uytkownikw?
	
	if ($num > 0) { // Po poprawnym wykonaniu zapytania zostan wywietlone rekordy.
	
		echo "<h1>Zarejestrowani uytkownicy</h1>";
	
		// W razie potrzeby zostan utworzone odnoniki do innych stron.
		if ($num_pages > 1) {
			
			echo '<p>';
			// Okrelenie strony zawierajcej skrypt.	
			$current_page = ($start/$display) + 1;
			
			// Jeli nie jest to pierwsza strona, wtedy zostanie utworzony przycisk 
                  // Poprzednia.
			if ($current_page != 1) {
				echo '<a href="view_users.php?s=' . ($start - $display) . '&np=' . $num_pages . '">Poprzednia</a> ';
			}
			
			// Wygenerowanie wszystkich ponumemerowanych stron.
			for ($i = 1; $i <= $num_pages; $i++) {
				if ($i != $current_page) {
					echo '<a href="view_users.php?s=' . (($display * ($i - 1))) . '&np=' . $num_pages . '">' . $i . '</a> ';
				} else {
					echo $i . ' ';
				}
			}
			
			// Jeli nie jest to ostatnia strona, wtedy zostanie utworzony przycisk 
                  // Nastpna.
			if ($current_page != $num_pages) {
				echo '<a href="view_users.php?s=' . ($start + $display) . '&np=' . $num_pages . '">Nastpna</a>';
			}
			
			echo '</p><br />';
			
		} // Koniec sekcji dotyczcej odnonikw.
		
		// Nagwek tabeli.
		echo '<table align="left" cellspacing="2" cellpadding="2">
		<tr><td align="left"><b>Nazwa</b></td><td align="left"><b>Data rejestracji</b></td></tr>';
		
		// Pobranie i wywietlenie wszystkich rekordw.
		$bg = '#eeeeee'; // Okrelenie koloru ta.
		while ($row = mysql_fetch_array($result, MYSQL_NUM)) {
   			$bg = ($bg=='#eeeeee' ? '#ffffff' : '#eeeeee'); // Ustawienie koloru ta.
			echo '<tr bgcolor="', $bg, '"><td align="left">', stripslashes($row[0]), '</td><td align="left">', $row[1], '</td></tr>
';
		}
	
		echo '</table>'; // Zamknicie tabeli.

		mysql_free_result ($result); // Uwolnienie zasobw.	
	
	} else { // Jeli nie zarejestrowano uytkownikw.
		echo '<h3>Aktualnie nie ma zarejestrowanych uytkownikw.</h3>'; 
	}
	
	mysql_close(); // Zamknicie poczenia z baz danych.
}

include_once ('../includes/admin_footer.html'); // Doczenie stopki HTML.
?>