<?php
# Skrypt 3.16 - formularzdaty.php

// Ustaw tytul strony i dolacz naglowek HTML.
$page_title = 'Formularz Kalendarza';
include ('./naglowek.inc');

// Ta funkcja tworzy trzy menu rozwijalne, po jednym dla dni, miesicy i lat.
function make_calendar_pulldown($this_month = NULL, $today = NULL, $year = NULL) {

	// Utworz tablice miesiecy.
	$months = array (1 => 'Stycze', 'Luty', 'Marzec', 'Kwiecie', 'Maj', 'Czerwiec', 'Lipiec', 'Sierpie', 'Wrzesie', 'Padziernik', 'Listopad', 'Grudzie');
	
	// Utwrz menu rozwijalne.
	echo '<select name="day">';
	for ($day = 1; $day <= 31; $day++) {
		echo "<option value=\"$day\"";
		if ($day == $today) {
			echo ' selected="selected"';
		}
		echo ">$day</option>\n";
	}

	echo '</select>
	<select name="month">';
	foreach ($months as $key => $value) {
		echo "<option value=\"$key\"";
		if ($value == $this_month) {
			echo ' selected="selected"';
		}
		echo ">$value</option>\n";
	}

	echo '</select>
	<select name="year">';
	
	if (!isset($year)) {
		$year = date('Y');	
	}
	while ($year <= 2010) {
		echo "<option value=\"$year\">$year</option>\n";
		$year++;
	}
	echo '</select>';
} // Koniec funkcji make_calendar_pulldown().

echo '<form action="formularzdaty.php" method="post">'; // Utworz formularz.

$dates = getdate();
make_calendar_pulldown ($dates['month'], $dates['mday'], $dates['year']); // Utworz kalendarz.
echo '</form>'; // Koniec formularza.

echo '<p>Dzi jest ', date ('l'), '. Jest godzina ', date ('g:i a'), '.</p>';
	
include ('./stopka.inc'); // Dolacz stopke HTML.
?>