<?php # Listing 13.9 - view_cart.php
// Strona suy do wywietlania zawartoci koszyka zakupw.

// Okrelenie tytuu strony i doczenie nagwka HTML.
$page_title = 'Przegldanie zawartoci koszyka zakupw';
include_once ('includes/header.html');

// Sprawdzenie czy formularz zosta wypeniony(aktualizacji koszyka zakupw).
if (isset ($_POST['submit'])) {
	foreach ($_POST['qty'] as $key => $value) {
		if ( ($value == 0) AND (is_numeric ($value)) ) {
			unset ($_SESSION['cart'][$key]);
		} elseif ( is_numeric ($value) AND ($value > 0) ) {
			$_SESSION['cart'][$key] = $value;
		}
	}
}

// Sprawdzenie czy koszyk zakupw jest pusty.
$empty = TRUE;
if (isset ($_SESSION['cart'])) {
	foreach ($_SESSION['cart'] as $key => $value) {
		if (isset($value)) {
			$empty = FALSE;	
		}
	} 
}	

// Wywietlenie koszyka zakupw jeli nie jest pusty.
if (!$empty) {

	require_once ('../mysql_connect.php'); // Nawizanie poczenia z baz danych.

	// Pobranie wszystkich informacji dotyczcych odbitek umieszczonych w koszyku.
	$query = 'SELECT * FROM artists, prints WHERE artists.artist_id = prints.artist_id AND prints.print_id IN (';
	foreach ($_SESSION['cart'] as $key => $value) {
		$query .= $key . ',';
	}
	$query = substr ($query, 0, -1) . ') ORDER BY artists.last_name ASC';
	$result = mysql_query ($query);
	
	// Utworzenie tabeli i formularza.
	echo '<table border="0" width="90%" cellspacing="3" cellpadding="3" align="center">
	<tr>
		<td align="left" width="30%"><b>Artysta</b></td>
		<td align="left" width="30%"><b>Nazwa odbitki</b></td>
		<td align="right" width="13%"><b>Cena</b></td>
		<td align="center" width="7%"><b>Ilo</b></td>
		<td align="right" width="10%"><b>Cakowita cena</b></td>
	</tr>
<form action="view_cart.php" method="post">
';

	// Wywietlenie kadej pozycji.
	$total = 0; // Cakowity koszt zamwienia.
	while ($row = mysql_fetch_array ($result, MYSQL_ASSOC)) {
		
		// Obliczenie sumy kocowej i czciowych.
		$subtotal = $_SESSION['cart'][$row['print_id']] * $row['price'];
		$total += $subtotal;
		
		// Wywietlenie wiersza.
		echo "	<tr>
		<td align=\"left\">{$row['first_name']} {$row['middle_name']} {$row['last_name']}</td>
		<td align=\"left\">{$row['print_name']}</td>
		<td align=\"right\">{$row['price']} z</td>
		<td align=\"center\"><input type=\"text\" size=\"3\" name=\"qty[{$row['print_id']}]\" value=\"{$_SESSION['cart'][$row['print_id']]}\" /></td>
		<td align=\"right\">" . number_format ($subtotal, 2) . " z</td>
	</tr>\n";
	} // Koniec ptli WHILE.
	
	// Wywietlenie stopki HTML oraz zamknicie tabeli i formularza.
	echo '	<tr>
		<td colspan="4" align="right"><b>Suma:<b></td>
		<td align="right">' . number_format ($total, 2) . ' z</td>
	</tr>
	</table><div align="center"><input type="submit" name="submit" value="Uaktualnij zawarto koszyka zakupw" /></form><br /><br /><a href="checkout.php"><font size="+3">Realizacja patnoci</font></a></div>';

	mysql_close(); // Zamknicie poczenia z baz danych.

} else {
	echo '<p>Aktualnie koszyk zakupw jest pusty.</p>';
}

include_once ('includes/footer.html'); // Doczenie stopki HTML.
?>