<?php # Listing 18.9 - logout.php
// Ten skrypt obsługuje wylogowanie.
require('includes/config.inc.php');
$page_title = 'Wylogowanie';
include('includes/naglowek.html');

// Jeśli w sesji nie istnieje zmienna first_name, przekierowujemy użytkownika
if (!isset($_SESSION['first_name'])) {

  $url = BASE_URL . 'index.php'; // definiujemy adres URL
  ob_end_clean(); // czyścimy bufor wyjściowy
  header("Location: $url");
  exit(); // kończymy działanie skryptu

} else { // wylogowujemy użytkownika

  $_SESSION = []; // usuwamy dane sesyjne
  session_destroy(); // usuwamy samą sesję
  setcookie(session_name(), '', time()-3600); // usuwamy ciasteczko

}

// wyświetlamy stosowny komunikat
echo '<h3>Zostałeś wylogowany.</h3>';

include('includes/stopka.html');
?>