<?php # Listing 10.4 - #4
// Ten skrypt pobiera wszystkie rekordy z tabeli users.
// Jego nowa wersja stronicuje prezentowane rekordy.

$page_title = 'Zobacz zarejestrowanych użytkowników';
include('includes/naglowek.html');
echo '<h1>Zarejestrowani użytkownicy</h1>';

require_once ('../mysqli_connect.php');

// liczba rekordów wyświetlanych na stronie
$display = 10;

// określamy ile będzie stron
if (isset($_GET['p']) && is_numeric($_GET['p'])) { // już to określiliśmy

  $pages = $_GET['p'];

} else { // dopiero musimy określić

  // określamy liczbę rekordów użytkowników
  $q = "SELECT COUNT(user_id) FROM users";
  $r = @mysqli_query($dbc, $q);
  $row = @mysqli_fetch_array($r, MYSQLI_NUM);
  $records = $row[0];

  // obliczamy liczbę stron
  if ($records > $display) { // więcej niż 1 strona
    $pages = ceil ($records/$display);
  } else {
    $pages = 1;
  }

} // koniec instrukcji IF

// określamy początek grupy pobieranych rekordów
if (isset($_GET['s']) && is_numeric($_GET['s'])) {
  $start = $_GET['s'];
} else {
  $start = 0;
}

// tworzymy zapytanie pobierające rekordy
$q = "SELECT last_name, first_name, DATE_FORMAT(registration_date, '%d %M %Y') AS dr, user_id FROM users ORDER BY registration_date ASC LIMIT $start, $display";
$r = @mysqli_query($dbc, $q);

// generujemy nagłówek tabeli
echo '<table width="60%">
<thead>
<tr>
  <th align="left"><strong>Edytuj</strong></th>
  <th align="left"><strong>Usuń</strong></th>
  <th align="left"><strong>Nazwisko</strong></th>
  <th align="left"><strong>Imię</strong></th>
  <th align="left"><strong>Data rejestracji</strong></th>
</tr>
</thead>
<tbody>
';

// pobieramy i wyświeltamy wszystkie rekordy

$bg = '#eeeeee'; // ustawiany początkowy kolor tła 

while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {

  $bg = ($bg=='#eeeeee' ? '#ffffff' : '#eeeeee'); // zmieniamy kolor tła

  echo '<tr bgcolor="' . $bg . '">
    <td align="left"><a href="edytuj_uzytkownika.php?id=' . $row['user_id'] . '">Edytuj</a></td>
    <td align="left"><a href="usun_uzytkownika.php?id=' . $row['user_id'] . '">Usuń</a></td>
    <td align="left">' . $row['last_name'] . '</td>
    <td align="left">' . $row['first_name'] . '</td>
    <td align="left">' . $row['dr'] . '</td>
  </tr>
  ';

} // koniec pętli WHILE

echo '</tbody></table>';
mysqli_free_result($r);
mysqli_close($dbc);

// generujmemy łącza do pozostałych stron, o ile to konieczne
if ($pages > 1) {

  // tworzymy odstęp i rozpoczynamy nowy akapit
  echo '<br><p>';

  // określamy na której stronie aktualnie się znajdujemy
  $current_page = ($start/$display) + 1;

  // jeśli nie na pierwszej, to generujemy łącze Poprzednia
  if ($current_page != 1) {
    echo '<a href="pokaz_uzytkownikow.php?s=' . ($start - $display) . '&p=' . $pages . '">Poprzednia</a> ';
  }

  // generujemy łącza reprezentowane przez liczby
  for ($i = 1; $i <= $pages; $i++) {
    if ($i != $current_page) {
      echo '<a href="pokaz_uzytkownikow.php?s=' . (($display * ($i - 1))) . '&p=' . $pages . '">' . $i . '</a> ';
    } else {
      echo $i . ' ';
    }
  } // koniec pętli FOR

  // jeśli nie jesteśmy na ostatniej stronie, to generujemy łącze Następna
  if ($current_page != $pages) {
    echo '<a href="pokaz_uzytkownikow.php?s=' . ($start + $display) . '&p=' . $pages . '">Następna</a>';
  }

  echo '</p>'; // kończymy akapit

} // koniec sekcji łączy

include('includes/stopka.html');
?>