# Polecenia SQL do książki"
# Autor: Larry Ullman, wydana we wrześniu 2017

# Ten plik zawiera polecania SQL CREATE, INSERT oraz ALTER, używane w książce, podzielone na rozdziały.
# Zostały one pobrane z punktów w tekście, gdzie są wykonywane w kliencie mysql.
# Polecenia SQL ze wskazówek i skryptów PHP nie zostały tu przedstawione.
# NIE NALEŻY próbować wykonywać tego pliku w całości - zamiast tego kopiuj, wklejaj i wykonuj poszczególne polecenia. 
# Plik jest zapisany z użyciem kodowania UTF-8, dzięki czemu może zawierać znaki z różnych alfabetów i języków. Więcej informacji o tym znajdziesz w rozdziale 6.


# ---------
# Rozdział 5.
# ---------

CREATE DATABASE sitename;

USE sitename;

CREATE TABLE users (
user_id MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,
first_name VARCHAR(20) NOT NULL,
last_name VARCHAR(40) NOT NULL,
email VARCHAR(60) NOT NULL,
pass CHAR(128) NOT NULL,
registration_date DATETIME NOT NULL,
PRIMARY KEY (user_id)
);

INSERT INTO users
(first_name, last_name, email, pass, registration_date)
VALUES ('Jan', 'Nowak', 'jan@jakissajt.pl', SHA2('mypass', 512), NOW());

INSERT INTO users VALUES
(NULL, 'Zuza', 'Isabella', 'zisa@jakissajt.pl', SHA2('mojito', 512), NOW());

INSERT INTO users (first_name, last_name, email, pass, registration_date) VALUES
('John', 'Lennon', 'john@beatles.com', SHA2('Happin3ss', 512), NOW()),
('Paul', 'McCartney', 'paul@beatles.com', SHA2('letITbe', 512), NOW()),
('George', 'Harrison', 'george@beatles.com ', SHA2('something', 512), NOW()),
('Ringo', 'Starr', 'ringo@beatles.com', SHA2('thisboy', 512), NOW());

INSERT INTO users (first_name, last_name, email, pass, registration_date) VALUES
('David', 'Jones', 'davey@monkees.com', SHA2('fasfd', 512), NOW()),
('Peter', 'Tork', 'peter@monkees.com', SHA2('warw', 512), NOW()),
('Micky', 'Dolenz', 'micky@monkees.com ', SHA2('afsa', 512), NOW()),
('Mike', 'Nesmith', 'mike@monkees.com', SHA2('abdfadf', 512), NOW()),
('Dawid', 'Sznyder', 'dawid@jakissajt.pl', SHA2('adfwrq', 512), NOW()),
('Norbi', 'Frankowski', 'norbi@jakissajt.pl', SHA2('jk78', 512), NOW()),
('Melisa', 'Nowakowska', 'melisa@jakissajt.pl', SHA2('jhk,h', 512), NOW()),
('Tomek', 'Morski', 'tomo@jakissajt.pl', SHA2('hdhd', 512), NOW()),
('Janusz', 'Poldecki', 'janpod@jakissajt.pl', SHA2('64654', 512), NOW()),
('Dominik', 'Wszelaki', 'dom@jakissajt.pl', SHA2('asf8', 512), NOW()),
('Grzesiek', 'Kwiatkowski', 'grzechu@jakissajt.pl', SHA2('5684eq', 512), NOW()),
('Michał', 'Król', 'michael@jakissajt.pl', SHA2('srw6', 512), NOW()),
('Rysio', 'Kowalski', 'rysko@jakissajt.pl', SHA2('zfs654', 512), NOW()),
('Romak', 'Kowalewski', 'rom.kow@jakissajt.pl', SHA2('wwr321', 512), NOW()),
('Hiacynt', 'Malinowski', 'himal@malinowscy.priv.pl', SHA2('5srw651', 512), NOW()),
('Maryna', 'Malinowska', 'maryna@malinowscy.priv.pl', SHA2('ljsa', 512), NOW()),
('Bartek', 'Malinowski', 'bart@malinowscy.priv.pl', SHA2('pwqojz', 512), NOW()),
('Liza', 'Malinowska', 'liza@malinowscy.priv.pl', SHA2('uh6', 512), NOW()),
('Magda', 'Malinowska', 'magda@malinowscy.priv.pl', SHA2('plda664', 512), NOW()),
('Aga', 'Malinowska', 'aga@alinowscy.priv.pl', SHA2('qopkrokr65', 512), NOW());

UPDATE users SET email='mike@jakissajt.pl' WHERE user_id = 14;

DELETE FROM users WHERE user_id = 8 LIMIT 1;


# ---------
# Rozdział 6.
# ---------

CREATE DATABASE forum CHARACTER SET utf8 COLLATE utf8_general_ci;
USE forum;

CREATE TABLE forums (
forum_id TINYINT UNSIGNED NOT NULL AUTO_INCREMENT,
name VARCHAR(60) NOT NULL,
PRIMARY KEY (forum_id),
UNIQUE (name)
) ENGINE = INNODB;

CREATE TABLE messages (
message_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
parent_id INT UNSIGNED NOT NULL DEFAULT 0,
forum_id TINYINT UNSIGNED NOT NULL,
user_id MEDIUMINT UNSIGNED NOT NULL,
subject VARCHAR(100) NOT NULL,
body LONGTEXT NOT NULL,
date_entered DATETIME NOT NULL,
PRIMARY KEY (message_id),
INDEX (parent_id),
INDEX (forum_id),
INDEX (user_id),
INDEX (date_entered)
) ENGINE = INNODB;

CREATE TABLE users (
user_id MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,
username VARCHAR(30) NOT NULL,
pass CHAR(128) NOT NULL,
first_name VARCHAR(20) NOT NULL,
last_name VARCHAR(40) NOT NULL,
email VARCHAR(60) NOT NULL,
PRIMARY KEY (user_id),
UNIQUE (username),
UNIQUE (email),
INDEX login (pass, email)
) ENGINE = INNODB;

CHARSET utf8;

INSERT INTO forums (name) VALUES
('MySQL'), ('yyPHP'), ('Sporty'),
('HTML'), ('CSS'), ('Kindlowanie');
INSERT INTO forums (name) VALUES ('Taniec nowoczesny');

INSERT INTO users (username, pass, first_name, last_name, email) VALUES
('miszczu', SHA2('haslo1', 512), 'Leszek', 'Borowski', 'ln@jakissajt.pl'),
('misiu', SHA2('malpka', 512), 'Dawid', 'Michalik', 'dm@jakissajt.pl'),
('gustlik', SHA2('asstmgr', 512), 'Grzegorz', 'Kowalski', 'gk@jakissajt.pl');
INSERT INTO users (username, pass, first_name, last_name, email)  VALUES
('tomek', SHA2('psychol', 512) , 'Tomasz', 'Kotebski', 'tk@jakissajt.pl'),
('agent', SHA2('bolek', 512), 'Krzysiek', 'Figowski', 'cf@jakissajt.pl');

SELECT * FROM forums;
SELECT user_id, username FROM users;
INSERT INTO messages (parent_id, forum_id, user_id, subject, body, date_entered) VALUES
(0, 1, 1, 'Pytanie dotyczące normalizacji.', 'Mam problem z postaciami normalnymi. Czytałem, że 2NF...', UTC_TIMESTAMP()),
(0, 1, 2, 'Projektowanie baz danych','Tworzę nową bazę i mam problem z określeniem jej struktury. Ile tabel powinienem utworzyć?...', UTC_TIMESTAMP()),
(2, 1, 2, 'Projektowanie baz danych','Liczba tabel w bazie zależy...', UTC_TIMESTAMP()),
(0, 1, 3, 'Projektowanie baz danych','Rozumiem, dzięki!', UTC_TIMESTAMP()),
(0, 2, 3, 'Błędy PHP', 'Mam problem z uruchomieniem przykładowego kalkulatora z 3. rozdziału. Kiedy wysyłam formularz...', UTC_TIMESTAMP());
INSERT INTO messages (parent_id, forum_id, user_id, subject, body, date_entered) VALUES
(5, 2, 1, 'Błędy PHP', 'Której wersji PHP używasz?', UTC_TIMESTAMP()),
(6, 2, 3, 'Błędy PHP', 'Używam wersji 5.2', UTC_TIMESTAMP()),
(7, 2, 1, 'Błędy PHP', 'W takim przypadku spróbuj wykonać czynności opisane w rozdziale 7.', UTC_TIMESTAMP()),
(0, 3, 2, 'Chicago Bulls', 'Czy Bullsi naprawdę mogą wygrać w tym roku?', UTC_TIMESTAMP()),
(9, 3, 1, 'Chicago Bulls', 'Nie wiem, ale na pewno grają doskonale!', UTC_TIMESTAMP()),
(0, 5, 3, 'Zasoby CSS', 'Gdzie mogę znaleźć więcej informacji na temat CSS?', UTC_TIMESTAMP()),
(11, 5, 1, 'Zasoby CSS', 'Przeczytaj świetną książkę Elizabeth Castro o (X)HTML-u i CSS. Albo poszukaj hasła "CSS" na Googlu.', UTC_TIMESTAMP()),
(0, 4, 3, 'HTML czy XHTML', 'Jakie są różnice pomiędzy HTML a XHTML?', UTC_TIMESTAMP()),
(13, 4, 1, 'HTML czy XHTML', 'XHTML jest połączeniem HTML i XML. Różnice dotyczą w głównej mierze składni. cośtam, cośtam, cośtam...', UTC_TIMESTAMP()),
(0, 6, 4, 'Dlaczego?', 'Po co wam forum o używaniu Kindla? Przecież to książka o PHP, MySQL, nieprawdaż?', UTC_TIMESTAMP()),
(0, 2, 3, 'Dynamiczne strony WWW z użyciem PHP', 'Czy mogę używać PHP do dynamicznego generowania kodu HTML na bieżąco? Z góry dziękuję...', UTC_TIMESTAMP()),
(16, 2, 1, 'Dynamiczne strony WWW z użyciem PHP', 'Oczywiście, że możesz.', UTC_TIMESTAMP()),
(17, 2, 3, 'Dynamiczne strony WWW z użyciem PHP, wciąż nie wiem', 'Świetnie, ale jak?', UTC_TIMESTAMP()),
(18, 2, 2, 'Dynamiczne strony WWW z użyciem PHP, clearer?', 'Myślę, że Larry stara się zasugerować ci kupno i pzeczytanie tej książki.', UTC_TIMESTAMP()),
(15, 6, 4, 'Dlaczego? Dlaczego? Dlaczego?', 'Poważnie się pytam - dlaczego?', UTC_TIMESTAMP()),
(20, 6, 1, 'No bo tak!', 'Albowiem', UTC_TIMESTAMP());

# Ograniczenia klucza obcego
USE test;
CREATE TABLE parent (
parent_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
PRIMARY KEY (parent_id)
);
INSERT INTO parent VALUES (1);

CREATE TABLE child (
child_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
parent_id INT UNSIGNED NOT NULL,
PRIMARY KEY (child_id),
FOREIGN KEY (parent_id) REFERENCES parent (parent_id)
);
INSERT INTO child VALUES (1,1);
DELETE FROM parent WHERE parent_id=1;
INSERT INTO child
(child_id, parent_id)
VALUES (NULL, 12343234);


CREATE DATABASE banking CHARACTER SET utf8 COLLATE utf8_general_ci;
USE banking;

CREATE TABLE customers (
customer_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
first_name VARCHAR(20) NOT NULL,
last_name VARCHAR(40) NOT NULL,
PRIMARY KEY (customer_id),
INDEX full_name (last_name, first_name)
) ENGINE = INNODB;

CREATE TABLE accounts (
account_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
customer_id INT UNSIGNED NOT NULL,
type ENUM('Operacyjne', 'Oszczędnościowe') NOT NULL,
balance DECIMAL(10,2) UNSIGNED NOT NULL DEFAULT 0.0,
PRIMARY KEY (account_id),
INDEX (customer_id),
FOREIGN KEY (customer_id) REFERENCES customers (customer_id) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE = INNODB;

CREATE TABLE transactions (
transaction_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
to_account_id INT UNSIGNED NOT NULL,
from_account_id INT UNSIGNED NOT NULL,
amount DECIMAL(5,2) UNSIGNED NOT NULL,
date_entered TIMESTAMP NOT NULL,
PRIMARY KEY (transaction_id),
INDEX (to_account_id),
INDEX (from_account_id),
INDEX (date_entered),
FOREIGN KEY (to_account_id) REFERENCES accounts (account_id)
ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (from_account_id) REFERENCES accounts (account_id)
ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE = INNODB;

INSERT INTO customers (first_name, last_name)
VALUES ('Szczepan', 'Jaracki'), ('Dawid', 'Prycel'), ('Kaja', 'Nowak');
INSERT INTO accounts (customer_id, balance)
VALUES (1, 5460.23), (2, 909325.24), (3, 892.00);
INSERT INTO accounts (customer_id, type, balance)
VALUES (2, 'Oszczędnościowe', 13546.97);

INSERT INTO accounts (customer_id, type, balance)
VALUES (10, 'Oszczędnościowe', 200.00);

# ---------
# Rozdział 7
# ---------

CREATE TABLE preferences (
receive_emails TINYINT UNSIGNED NOT NULL
)

ALTER TABLE messages ADD FULLTEXT (body, subject);
ALTER TABLE customers ADD COLUMN pin VARBINARY(16) NOT NULL;
ALTER TABLE customers ADD COLUMN nacl VARBINARY(64) NOT NULL;

UPDATE customers SET nacl = UNHEX(SHA2(RAND(), 512)) WHERE customer_id=1;
UPDATE customers SET pin=AES_ENCRYPT(1234, nacl) WHERE customer_id=1;

# ---------
# Rozdział 17.
# ---------

SET NAMES utf8;

CREATE DATABASE forum2 CHARACTER SET utf8;
USE forum2;

CREATE TABLE languages (
lang_id TINYINT UNSIGNED NOT NULL AUTO_INCREMENT,
lang VARCHAR(60) NOT NULL,
lang_eng VARCHAR(20) NOT NULL,
PRIMARY KEY (lang_id),
UNIQUE (lang)
);

CREATE TABLE threads (
thread_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
lang_id TINYINT(3) UNSIGNED NOT NULL,
user_id INT UNSIGNED NOT NULL,
subject VARCHAR(150) NOT NULL,
PRIMARY KEY  (thread_id),
INDEX (lang_id),
INDEX (user_id)
);

CREATE TABLE posts (
post_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
thread_id INT UNSIGNED NOT NULL,
user_id INT UNSIGNED NOT NULL,
message TEXT NOT NULL,
posted_on DATETIME NOT NULL,
PRIMARY KEY (post_id),
INDEX (thread_id),
INDEX (user_id)
);

CREATE TABLE users (
user_id MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,
lang_id TINYINT UNSIGNED NOT NULL,
time_zone VARCHAR(30) NOT NULL,
username VARCHAR(30) NOT NULL,
pass VARCHAR(255) NOT NULL,
email VARCHAR(60) NOT NULL,
PRIMARY KEY (user_id),
UNIQUE (username),
UNIQUE (email),
INDEX login (username, pass)
);

CREATE TABLE words (
word_id TINYINT UNSIGNED NOT NULL AUTO_INCREMENT,
lang_id TINYINT UNSIGNED NOT NULL,
title VARCHAR(80) NOT NULL,
intro TINYTEXT NOT NULL,
home VARCHAR(30) NOT NULL,
forum_home VARCHAR(40) NOT NULL,
`language` VARCHAR(40) NOT NULL,
register VARCHAR(30) NOT NULL,
login VARCHAR(30) NOT NULL,
logout VARCHAR(30) NOT NULL,
new_thread VARCHAR(40) NOT NULL,
subject VARCHAR(30) NOT NULL,
body VARCHAR(30) NOT NULL,
submit VARCHAR(30) NOT NULL,
posted_on VARCHAR(30) NOT NULL,
posted_by VARCHAR(30) NOT NULL,
replies VARCHAR(30) NOT NULL,
latest_reply VARCHAR(40) NOT NULL,
post_a_reply VARCHAR(40) NOT NULL,
PRIMARY KEY (word_id),
UNIQUE (lang_id)
);

INSERT INTO languages (lang, lang_eng) VALUES
('English', 'English'),
('Português', 'Portuguese'),
('Français', 'French'),
('Norsk', 'Norwegian'),
('Romanian', 'Romanian'),
('Ελληνικά', 'Greek'),
('Deutsch', 'German'),
('Srpski', 'Serbian'),
('日本語', 'Japanese'),
('Nederlands', 'Dutch'),
('Polski', 'Polish');

INSERT INTO users (lang_id, time_zone, username, pass, email) VALUES
(1, 'US/Eastern', 'troutster', '', 'email@jakissajt.org'),
(7, 'Europe/Berlin', 'Ute', '', 'email1@jakissajt.org'),
(4, 'Europe/Oslo', 'Silje', '', 'email2@jakissajt.org'),
(2, 'America/Sao_Paulo', 'João', '', 'email3@jakissajt.org'),
(1, 'Pacific/Auckland', 'kiwi', '', 'kiwi@jakissajt.org'),
(11, 'Europe/Warsaw', 'Bolek', '', 'ag.bolek@jakissajt.pl');

INSERT INTO words VALUES
(NULL,1, 'PHP and MySQL for Dynamic Web Sites: The Forum!', '<p>Welcome to our site....please use the links above...blah,  blah,  blah.</p>\r\n<p>Welcome to our site....please use the links above...blah,  blah, blah.</p>', 'Home', 'Forum Home', 'Language', 'Register', 'Login', 'Logout', 'New Thread', 'Subject', 'Body', 'Submit', 'Posted on', 'Posted by', 'Replies', 'Latest Reply', 'Post a Reply'),
(NULL,4, 'PHP og MySQL for Dyaniske Websider: Forumet!', '<p>Velkommen til denne siden. Introduksjonstekst.</p>\r\n<p>Velkommen til denne siden. Introduksjonstekst.</p>', 'Hjem', 'Forumet Hjem', 'Språk', 'Registrer deg', 'Logg inn', 'Logg ut', 'Ny tråd', 'Emne', 'Kropp', 'SUBMIT', 'Lagt til', 'Lagt til av', 'REPLIES', 'LATEST REPLY', 'POST A REPLY'),
(NULL,5, 'Forumul PHP si MySQL pentru site-uri web dinamice', 'Bine ati venit pe acest site. Text introductiv. Bine ati venit pe acest site. Text introductiv. Bine ati venit pe acest site. Text introductiv.', 'Acasa', 'Forumul Acasa', 'Limba', 'Inregistrare', 'Conectare', 'Deconectare', 'Discutie noua', 'Subiect', 'Continut', 'SUBMIT', 'Afisat pe', 'Afisat de', 'REPLIES', 'LATEST REPLY', 'POST A REPLY'),
(NULL,3, 'Sites internet dynamiques avec PHP et MySQL : le forum!', 'Bienvenue sur ce site. Texte d''introduction. Bienvenue sur ce site. Texte d''introduction. Bienvenue sur ce site. Texte d''introduction.', 'Accueil', 'Le Forum Accueil', 'Langue', 'S''enregistrer', 'Se connecter', 'Déconnexion', 'Nouvelle discussion', 'Sujet', 'Contenu', 'Soumettez', 'Posté le', 'Posté par', 'Réponses', 'La Plus défunte Réponse', 'Signalez une réponse'),
(NULL,7, 'PHP en MYSQL voor Dynamische Websites: Het Forum!', 'Welkom op deze site! Inleidingstekst. Hier vind je alles op het gebied van php!', 'Index', 'Forum Index', 'Taal', 'Registreer', 'Uitloggen', 'Inloggen', 'Nieuw onderwerp', 'Onderwerp', 'Body', 'SUBMIT', 'Geplaatst op', 'Geplaatst door', 'REPLIES', 'LATEST REPLY', 'POST A REPLY'),
(NULL,9, 'PHP とMySqlでのだいなみっくなウエブサイト：フォラムです！', 'ようこそこのウエブサイトにおいでくださいました。紹介文。 ようこそこのウエブサイトにおいでくださいました。紹介文。', '話題', '返答を提示', '新しい スレツド ', 'ホーム', 'フォラムのホウムペイジ', '言語', 'レジスター', ' ログイン', 'ログアウト', '本文', 'サブミット', '掲示日', ' 掲示者', '返答数', '最新の返答'),
(NULL, 11, 'PHP i MySQL. Dynamiczne strony WWW. Szybki start. Forum książki', 'Witamy na stronach naszej witryny!', 'Strona domowa', 'Forum domowe', 'Język', 'Rejestracja', 'Logowanie', 'Wylogowanie', 'Nowy wątek', 'Temat', 'Treść', 'Wstaw', 'Data wstawienia', 'Autor', 'Odpowiedzi', 'Ostatnia odpowiedź', 'Wstaw odpowiedź');
;

INSERT INTO `threads` (`thread_id`, `lang_id`, `user_id`, `subject`) VALUES
(1, 4, 1, 'Byttet til PHP 7.0 fra PHP 5.0 - variabler utilgjengelige'),
(2, 4, 2, 'Automatisk bildekontroll'),
(3, 3, 5, 'Lancer une Page HTML en PHP'),
(4, 3, 4, 'Ajouter des adresses a PHP List depuis un formulaire'),
(5, 9, 4, '取引をおこなう'),
(7, 1, 1, 'Sample Thread'),
(8, 11, 6, 'Przykładowy wątek na forum');

INSERT INTO `posts` (`post_id`, `thread_id`, `user_id`, `message`, `posted_on`) VALUES
(1, 1, 3, 'Jeg har nettopp gått over til PHP 5.0 og forsøkte å benytte meg av mine gamle scripts. Dette viste seg å være noe vanskelig ettersom de bare generer feil. Hovedproblemet virker å være at jeg ikke får tilgang til variabler som tidligere var tilgjengelige. Noen som har noen forslag?', '2017-10-29 04:15:52'),
(2, 1, 1, 'Har du sjekket om variablene du prøver å få tilgang på er superglobals? Dette forandret seg fra 4.2 og utover, tror jeg...', '2017-10-29 04:20:52'),
(3, 1, 4, 'Hva er superglobals?', '2017-10-29 04:30:30'),
(4, 1, 1, 'http://no.php.net/variables.predefined', '2017-10-30 06:16:30'),
(5, 1, 5, 'Linken Terje ga er manualsiden, men du kan også ta en titt på http://www.linuxjournal.com/article/6559 for en grundig innføring og forklaring. Lykke til!', '2017-10-29 10:26:57'),
(6, 2, 2, 'Har sett flere sider hvor man må skrive inn noen tall for å kunne laste ned, registrere seg, osv. Er dette PHP? Kan noen hjelpe meg å få til en slik?', '2017-10-29 22:45:57'),
(7, 3, 1, 'Je voudrais afficher simplement une nouvelle page HTML ou PHP dans mon\r\nnavigateur web depuis un bout de programme en PHP.\r\nLancer par exemple http://www.google.fr/ depuis un condition if (a>0)\r\nJe trouve pas de solution sur google ni dans mes bouquins', '2017-10-29 04:42:38'),
(8, 3, 2, 'header("Location: http://www.domaine.com");\r\nAttention, cette fonction doit être utilisé avant toute sortie vers le navigateur... le moindre echo et c''est foutu\r\n', '2017-10-29 05:17:38'),
(9, 4, 3, 'J''utilise PHP List. J''ai un formulaire contact avec une case à cocher\r\npermettant de choisir de s''abonner à une newsletter. Je traite ce\r\nformullaire en PHP.\r\nExiste-t-il un moyen au moment où je traite le formulaire d''ajouter la\r\npersonne dans ma liste de diffusion PHP List ?\r\nJe suppose que le problème n''est pas compliqué mais je n''ai pas encore\r\ntrouvé comment faire...\r\n', '2017-10-29 04:43:28'),
(10, 4, 5, 'Dans ce genre de problématiques le mieux est de :\r\na/ regarder de quelle manière php list gère les abonnés dans la base ( en\r\ngros, regarder la structure de la table ).\r\nb/ créer une fonction qui ajoute manuellement les données de votre\r\nformulaire dans la ou les tables mysql utilisée(s) par php list ( en se\r\nméfiant des doublons : est ce que cette adresse est déjà dans la liste ? )\r\nc/ faire un ou plusieurs tests...\r\n', '2017-10-31 12:06:28'),
(11, 5, 2, 'PHP を使って　MySqlでは、取引を どのようにしたら良いかと　\r\nまよっています。良い方法が、あったらおしえてください。', '2017-10-29 04:57:55'),
(12, 5, 3, '次のようにしたらどうですか？', '2017-10-29 04:57:55'),
(13, 5, 4, '反れとも、このようにも　できます。', '2017-10-29 04:58:10'),
(14, 7, 1, 'This is the body of the sample thread. This is the body of the sample thread. This is the body of the sample thread. ', '2017-10-29 05:12:02'),
(15, 7, 1, 'I like your thread. It''s simple and sweet.', '2017-10-29 05:44:07'),
(16, 8, 6, 'To jest treść przykładowego wątku. To jest treść przykładowego wątku. To jest treść przykładowego wątku. ', '2017-10-29 05:12:02'),
(17, 8, 6, 'Ten wątek jest odlotowy. Taki kreatywny... Ubóstwiam go!', '2017-10-29 05:44:07');


# ----------
# Rozdział 18.
# ----------

CREATE DATABASE r18;

USE r18;

CREATE TABLE users (
user_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
first_name VARCHAR(20) NOT NULL,
last_name VARCHAR(40) NOT NULL,
email VARCHAR(80) NOT NULL,
pass CHAR(40) NOT NULL,
user_level TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
active CHAR(32),
registration_date DATETIME NOT NULL,
PRIMARY KEY (user_id),
UNIQUE KEY (email),
INDEX login (email, pass)
);


# ----------
# Rozdział 19.
# ----------

CREATE DATABASE ecommerce;

USE ecommerce;

CREATE TABLE artists (
artist_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
first_name VARCHAR(20) DEFAULT NULL,
middle_name VARCHAR(20) DEFAULT NULL,
last_name VARCHAR(40) NOT NULL,
PRIMARY KEY (artist_id),
UNIQUE full_name (last_name, first_name, middle_name)
) ENGINE=MyISAM;

CREATE TABLE prints (
print_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
artist_id INT UNSIGNED NOT NULL,
print_name VARCHAR(60) NOT NULL,
price DECIMAL(6,2) UNSIGNED NOT NULL,
size VARCHAR(60) DEFAULT NULL,
description VARCHAR(255) DEFAULT NULL,
image_name VARCHAR(60) NOT NULL,
PRIMARY KEY (print_id),
INDEX (artist_id),
INDEX (print_name),
INDEX (price)
) ENGINE=MyISAM;

CREATE TABLE customers (
customer_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
email VARCHAR(60) NOT NULL,
pass CHAR(40) NOT NULL,
PRIMARY KEY (customer_id),
UNIQUE (email),
INDEX login (email, pass)
) ENGINE=MyISAM;

CREATE TABLE orders (
order_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
customer_id INT UNSIGNED NOT NULL,
total DECIMAL(10,2) UNSIGNED NOT NULL,
order_date TIMESTAMP,
PRIMARY KEY (order_id),
INDEX (customer_id),
INDEX (order_date)
) ENGINE=InnoDB;

CREATE TABLE order_contents (
oc_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
order_id INT UNSIGNED NOT NULL,
print_id INT UNSIGNED NOT NULL,
quantity TINYINT UNSIGNED NOT NULL DEFAULT 1,
price DECIMAL(6,2) UNSIGNED NOT NULL,
ship_date DATETIME default NULL,
PRIMARY KEY (oc_id),
INDEX (order_id),
INDEX (print_id),
INDEX (ship_date)
) ENGINE=InnoDB;