<?php # Listing 18.8 - login.php
// Ten skrypt obsługuje logowanie użytkownika.
require('includes/config.inc.php');
$page_title = 'Logowanie';
include('includes/naglowek.html');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  require(MYSQL);

  // sprawdzamy poprawność adresu e-mail
  if (!empty($_POST['email'])) {
    $e = mysqli_real_escape_string($dbc, $_POST['email']);
  } else {
    $e = FALSE;
    echo '<p class="error">Zapomniałeś podać adresu e-mail!</p>';
  }

  // sprawdzamy hasło
  if (!empty($_POST['pass'])) {
    $p = trim($_POST['pass']);
  } else {
    $p = FALSE;
    echo '<p class="error">Zapomniałeś podać hasła!</p>';
  }

  if ($e && $p) { // wszystko w porządku

    // zapytanie do bazy
    $q = "SELECT user_id, first_name, user_level, pass FROM users WHERE email='$e' AND active IS NULL";
    $r = mysqli_query($dbc, $q) or trigger_error("Polecenie SQL: $q\n<br>Błąd MySQL: " . mysqli_error($dbc));

    if (@mysqli_num_rows($r) == 1) { // znaleziono pasujący rekord

      // pobieramy wartości z rekordu
      list($user_id, $first_name, $user_level, $pass) = mysqli_fetch_array($r, MYSQLI_NUM);
      mysqli_free_result($r);

      // sprawdzamy hasło
      if (password_verify($p, $pass)) {

        // zapisujemy informacje z rekordu w sesji
        $_SESSION['user_id'] = $user_id;
        $_SESSION['first_name'] = $first_name;
        $_SESSION['user_level'] = $user_level;
        mysqli_close($dbc);

        // przekierowujemy użytkownika
        $url = BASE_URL . 'index.php'; // definiujemy adres URL
        ob_end_clean(); // czyścimy bufor wyjściowy
        header("Location: $url");
        exit(); // kończymy działanie skryptu

      } else {

        echo '<p class="error">Adres e-mail lub hasło nie pasują do tych zapisanych w bazie, bądź też jeszcze nie aktywowałeś konta.</p>';
      }

    } else { // nie znaleziono pasującego rekordu
      echo '<p class="error">Adres e-mail lub hasło nie pasują do tych zapisanych w bazie, bądź też jeszcze nie aktywowałeś konta.</p>';
    }

  } else { // jeśli coś poszło źle...
    echo '<p class="error">Proszę spróbować jeszcze raz.</p>';
  }

  mysqli_close($dbc);

} // koniec głównej instrukcji IF
?>

<h1>Logowanie</h1>
<p>Aby się zalogować, przeglądarka musi obsługiwać ciasteczka.</p>
<form action="login.php" method="post">
  <fieldset>
  <p><strong>Adres e-mail:</strong> <input type="email" name="email" size="20" maxlength="60"></p>
  <p><strong>Hasło:</strong> <input type="password" name="pass" size="20"></p>
  <div align="center"><input type="submit" name="submit" value="Logowanie"></div>
  </fieldset>
</form>

<?php include('includes/stopka.html'); ?>