<?php # Listing 16.3 - pokaz_uzytkownikow.php #6
// Ten listing odczytuje wszystkie rekordy z tabeli users.
// To jest obiektowa wersja skryptu z rozdziału 10.

$page_title = 'Zobacz zarejestrowanych użytkowników';
include ('includes/naglowek.html');

// wyświetlamy nagłówek strony
echo '<h1>Zarejestrowani użytkownicy</h1>';

require('../mysqli_oop_connect.php'); // nawiązujemy połączenie z bazą danych

// tworzymy zapytanie
$q = "SELECT CONCAT(last_name, ', ', first_name) AS name, DATE_FORMAT(registration_date, '%M %d, %Y') AS dr FROM users ORDER BY registration_date ASC";
$r = $mysqli->query($q); // wykonujemy zapytanie

// określamy liczbę zwróconych rekordów
$num = $r->num_rows;

if ($num > 0) { // jeżeli zapytanie zwróciło jakieś rekordy, to je wyświetlamy

  // wyświetlamy liczbę użytkowników
  echo "<p>W chwili obecnej mamy $num zarejestrowanych użytkowników.</p>\n";

  // wyświetlamy nagłówek tabeli
  echo '<table width="60%">
  <thead>
  <tr><td align="left"><strong>Nazwisko</strong></td><td align="left"><strong>Data rejestracji</strong></td></tr>
  </thead>
  <tbody>
';

  // pobieramy i wyświetlamy wszystkie rekordy
  while ($row = $r->fetch_object()) {
    echo '<tr><td align="left">' . $row->name . '</td><td align="left">' . $row->dr . '</td></tr>
    ';
  }

  echo '</tbody></table>'; // zamykamy tabelę

  $r->free(); // zwalniamy zasoby
  unset($r);

} else { // jeżeli zapytanie nie zostało wykonane pomyślnie...

  echo '<p class="error">Aktualnie nie ma żadnych zarejestrowanych użytkowników.</p>';

}

// zamykamy połączenie z bazą danych
$mysqli->close();
unset($mysqli);

include ('includes/stopka.html');
?>