<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Obrazki</title>
  <script charset="utf-8" src="js/function.js"></script>
</head>
<body>
<p>Kliknij obrazek, by wyświetlić go w nowym oknie przeglądarki.</p>
<ul>
<?php # Listing 11.6 - images.php
// Ten skrypt wyświetla obrazki dostępne w katalogu uploads.
// Ta wersja skryptu dla każdego pliku obrazka pokazuje jego wielkość i datę/czas modyfikacji.

// ustawiamy strefę czasową
date_default_timezone_set('Europe/Warsaw');

$dir = '../uploads'; // definiujemy katalog z obrazkami

$files = scandir($dir); // odczytujemy zawartość katalogu i zapisujemy ją w tablicy

// wyświetlamy nazwę każdego obrazka jako łącze wywołujące funkcję JavaScript
foreach ($files as $image) {

  if (substr($image, 0, 1) != '.') { // ignorujemy wszystko zaczynając do znaku "."

    // określamy wielkość obrazka w piskelach
    $image_size = getimagesize("$dir/$image");

    // wyznaczamy wielkość pliku w kilobajtach
    $file_size = round( (filesize("$dir/$image")) / 1024) . "KB";

    // odczytujemy datę i czas przesłania pliku na serwer
    $image_date = date("d F Y H:i:s", filemtime("$dir/$image"));

    // zapisujemy nazwę obrazka w sposób umożliwiający umieszczenie jej w adresie URL
    $image_name = urlencode($image);

    // wyświetlamy nazwę w formie łącza
    echo "<li><a href=\"javascript:create_window('$image_name',$image_size[0],$image_size[1])\">$image</a> $file_size ($image_date)</li>\n";

  } // koniec instrukcji IF

} // koniec pętli FOREACH

?>
</ul>
</body>
</html>