<?php # Listing 10.3 - edytuj_uzytkownika.php
// Ten skrytp umożliwia edycję danych użytkownika.
// Jest on wywoływany ze strony pokaz_uzytkownikow.php.

$page_title = 'Edycja użytkownika';
include ('includes/naglowek.html');
echo '<h1>Edytuj użytkownika</h1>';

// sprawdzamy poprawność identyfikatora przekazanego za pomocą metody GET lub POST.
if ( (isset($_GET['id'])) && (is_numeric($_GET['id'])) ) { // przekazany ze skryptu pokaz_uzytkownika.php
  $id = $_GET['id'];
} elseif ( (isset($_POST['id'])) && (is_numeric($_POST['id'])) ) { // przesłanie formularza
  $id = $_POST['id'];
} else { // brak poprawnego identyfikatora, zakończymy skrypt
  echo '<p class="error">Błąd podczas dostępu do strony.</p>';
  include ('includes/stopka.html'); 
  exit();
}

require('../mysqli_connect.php'); 

// sprawdzamy, czy formularz został wysłany.
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  $errors = [];
  
  // sprawdzamy imię
  if (empty($_POST['first_name'])) {
    $errors[] = 'Zapomniałeś wprowadzić swoje imię!';
  } else {
    $fn = mysqli_real_escape_string($dbc, trim($_POST['first_name']));
  }
  
  // sprawdzamy nazwisko
  if (empty($_POST['last_name'])) {
    $errors[] = 'Zapomniałeś wprowadzić swoje nazwisko!';
  } else {
    $ln = mysqli_real_escape_string($dbc, trim($_POST['last_name']));
  }
  
  // sprawdzamy adres e-mail
  if (empty($_POST['email'])) {
    $errors[] = 'Zapomniałeś wprowadzić adres e-mail.';
  } else {
    $e = mysqli_real_escape_string($dbc, trim($_POST['email']));
  }
  
  if (empty($errors)) { // jeśli formularz wypełniony poprawnie
  
    // sprawdzamy unikalność adresu email
    $q = "SELECT user_id FROM users WHERE email='$e' AND user_id != $id";
    $r = @mysqli_query($dbc, $q);
    if (mysqli_num_rows($r) == 0) {

      // tworzymy polecenie UPDATE
      $q = "UPDATE users SET first_name='$fn', last_name='$ln', email='$e' WHERE user_id=$id LIMIT 1";
      $r = @mysqli_query ($dbc, $q);
      if (mysqli_affected_rows($dbc) == 1) { // jeśli polecenie wykonano poprawnie
      
        // wyświetlamy komunikat
        echo '<p>Dane użytkownika zostały zmienione.</p>';  
              
      } else { // w przeciwnym razie
        echo '<p class="error">Dane użytkownika nie zostały zmienione ze względu na błąd systemu. Przepraszamy za utrudnienia.</p>'; // komunikat dla użytkownika
        echo '<p>' . mysqli_error($dbc) . '<br>Zapytanie: ' . $q . '</p>'; // komunikat uruchomieniowy
      }
        
    } else { // użytkownik już jest zarejestrowany
      echo '<p class="error">Podany adres e-mail jest już zarejestrowany.</p>';
    }
    
  } else { // wyświetlamy komunikaty o błędach
  
    echo '<p class="error">Wystąpiły następujące błędy:<br>';
    foreach ($errors as $msg) { // wyświetlamy każdy komunikat o błędzie
      echo " - $msg<br>\n";
    }
    echo '</p><p>Spróbuj jeszcze raz.</p>';
    
  } // koniec instrukcji warunkowej if (empty($errors)).

} // koniec instrukcji warunkowej wysłania formularza

// generujemy formularz

// pobieramy informacje o użytkowniku
$q = "SELECT first_name, last_name, email FROM users WHERE user_id=$id";    
$r = @mysqli_query ($dbc, $q);

if (mysqli_num_rows($r) == 1) { // poprawny identyfikator użytkownika, wyświetlamy formularz.

  // pobieramy informacje
  $row = mysqli_fetch_array ($r, MYSQLI_NUM);
  
  // generujemy formularz
  echo '<form action="edytuj_uzytkownika.php" method="post">
    <p>Imię: <input type="text" name="first_name" size="15" maxlength="15" value="' . $row[0] . '" /></p>
    <p>Nazwisko: <input type="text" name="last_name" size="15" maxlength="30" value="' . $row[1] . '" /></p>
    <p>Adres e-mail: <input type="text" name="email" size="20" maxlength="60" value="' . $row[2] . '"  /> </p>
    <p><input type="submit" name="submit" value="Wyślij" /></p>
    <input type="hidden" name="id" value="' . $id . '" />
    </form>';

} else { // identyfikator użytkownika jest nieprawidłowy
  echo '<p class="error">Błąd dostępu do strony.</p>';
}

mysqli_close($dbc);
    
include ('includes/stopka.html');
?>