<!doctype html>
<html lang="pl">
<head>
<meta charset="utf-8">
  <title>Obsługa błędów</title>
</head>
<body>

<h2>Testowanie obsługi błędów</h2>
<?php # Listing 8.3 - obsluz_bledy.php

// Znacznik okreslający status witryny.
define('LIVE', FALSE);

// Funkcja obsługi błędów
function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {

  // Tworzymy komunikat o błędzie.
  $message = "W skrypcie '$e_file' w wierszu $e_line wystąpił następujący błąd: $e_message\n";
  
  // Dołączamy $e_vars do $message.
  $message .= print_r ($e_vars, 1);

  if (!LIVE) { // Witryna w trakcie tworzenia (wyświetlamy błąd).
    echo '<pre>' . $message . "\n";
    debug_print_backtrace();
    echo '</pre><br />';
  } else { // Nie wyświetlamy szczegółowej informacji o błędzie.
    echo '<div class="error">Wystąpił błąd w pracy systemu. Przepraszamy za utrudnienia.</div><br />';    
  }

} // Koniec definicji funkcji my_error_handler().

// Konfigurujemy funkcję obsługi błędów.
set_error_handler ('my_error_handler');

// Wywołujemy błędy.
foreach ($var as $v) {}
$result = 1/0;

?>
</body>
</html>