<?php # Listing 17.8 - search.php
// Ten skrypt wyświetla i obsługuje formularz wyszukiwania

// dołączamy plik nagłówka strony 
include('includes/naglowek.html');

// wyświetlamy formularz wyszukiwania
echo '<form action="search.php" method="get" accept-charset="utf-8">
<p><em>' . $words['search'] . '</em>: <input name="terms" type="text" size="30" maxlength="60" ';

// sprawdzamy, czy przesłano poszukiwane słowa
if (isset($_GET['terms'])) {
	echo 'value="' . htmlspecialchars($_GET['terms']) . '" ';
}

// kończymy wyświetlanie formularza
echo '><input name="submit" type="submit" value="' . $words['submit'] . '"></p></form>';

if (isset($_GET['terms'])) { // obsługa formularza

	// przygotowujemy poszukiwanie słowa
	$terms = mysqli_real_escape_string($dbc, htmlentities(strip_tags($_GET['terms'])));

	// wykonujemy zapytanie
	$q = "SELECT * FROM languages WHERE lang_id = 100";
	$r = mysqli_query($dbc, $q);
	if (mysqli_num_rows($r) > 0) {
		echo '<h2>Wyniki wyszukiwania</h2>';
	} else {
		echo '<p>Nic nie znaleziono.</p>';
	}

}

// Include the HTML footer file:
include('includes/stopka.html');
?>
