<?php # Listing 17.5 - read.php
// Ta strona wyświetla wszystkie wiadomości w wątku.
include('includes/naglowek.html');

// sprawdzamy identyfikator wątku
$tid = FALSE;
if (isset($_GET['tid']) && filter_var($_GET['tid'], FILTER_VALIDATE_INT, array('min_range' => 1)) ) {

  // tworzymy skrócone odwołanie od identyfikatora wątku
  $tid = $_GET['tid'];

  // konwertujemy datę jeśli użytkownik jest zalogowany
  if (isset($_SESSION['user_tz'])) {
    $posted = "CONVERT_TZ(p.posted_on, 'UTC', '{$_SESSION['user_tz']}')";
  } else {
    $posted = 'p.posted_on';
  }

  // wykonujemy zapytanie
  $q = "SELECT t.subject, p.message, username, DATE_FORMAT($posted, '%e-%b-%y %l:%i %p') AS posted FROM threads AS t LEFT JOIN posts AS p USING (thread_id) INNER JOIN users AS u ON p.user_id = u.user_id WHERE t.thread_id = $tid ORDER BY p.posted_on ASC";
  $r = mysqli_query($dbc, $q);
  if (!(mysqli_num_rows($r) > 0)) {
    $tid = FALSE; // błędny identyfikator wątku
  }

} // koniec instrukcji IF isset($_GET['tid'])

if ($tid) { // pobieramy wiadomości w wątku

  $printed = FALSE; // flaga

  // pobieramy każdą wiadomość
  while ($messages = mysqli_fetch_array($r, MYSQLI_ASSOC)) {

    // temat należy wyświetlać tylko raz
    if (!$printed) {
      echo "<h2>{$messages['subject']}</h2>\n";
      $printed = TRUE;
    }

    // wyświetlamy wiadomość
    echo "<p>{$messages['username']} ({$messages['posted']})<br>{$messages['message']}</p><br>\n";

  } // koniec pętli WHILE

  // wyświetlamy formularz do dodawania wiadomości
  include('includes/post_form.php');

} else { // nieprawidłowy identyfikator wątku
  echo '<p class="bg-danger">Błąd podczas dostępu do strony.</p>';
}

include('includes/stopka.html');
?>