<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Stosowanie klasy DateTime</title>
  <style>
  body {
    font-family: Verdana, Arial, Helvetica, sans-serif;
    font-size: 12px;
    margin: 10px;
  }
  label { font-weight: bold; }
  .error { color: #F00; }
  </style>
</head>
<body>
<?php # Listing 16.5 - data_czas.php

// datę początku ustawiamy na dziś, a końca - na jutro
$start = new DateTime();
$end = new DateTime();
$end->modify('+1 day');

// określamy domyślny format prezentacji dat
$format = 'Y-m-d';

// Ta funkcja sprawdza poprawność przekazanej daty.
// Jeśli data jest poprawna, zwracana jest tablica [miesiąc, dzień, rok].
function validate_date($date) {

  // dzielimy łańcuch znaków na części
  $array = explode('-', $date);

  // jeśli liczba fragmentów jest różna od 3, zwracamy false
  if (count($array) != 3) return false;

  // jeśli to nie jest prawidłowa data, zwracamy false
  if (!checkdate($array[1], $array[2], $array[0])) return false;

  // zwracamy tablicę
  return $array;

} // koniec funkcji validate_date()

// sprawdzamy czy zostały przesłane dane
if (isset($_POST['start'], $_POST['end'])) {

  // sprawdzamy poprawność obu przesłanych dat
  if ( (list($sy, $sm, $sd) = validate_date($_POST['start'])) && (list($ey, $em, $ed) = validate_date($_POST['end'])) ) {

    // jeśli daty są prawidłowe, modyfikujemy obiekty DateTime
    $start->setDate($sy, $sm, $sd);
    $end->setDate($ey, $em, $ed);

    // sprawdzamy czy data początku jest wcześniejsza
    if ($start < $end) {

      // wyznaczamy odstęp pomiędzy datami
      $interval = $start->diff($end);

      // wyświetlamy wyniki
      echo "<p>Zdarzenie rozpoczyna się dnia {$start->format($format)} i kończy dnia {$end->format($format)}, czyli jego długość wynosi $interval->days dni.</p>";

    } else { // data końca musi być późniejsza
      echo '<p class="error">Data początku musi wypadać przed datą końca.</p>';
    }

  } else { // nieprawidłowa data
    echo '<p class="error">Jedna lub obie podane daty są nieprawidłowe.</p>';
  }

} // koniec obsługi formularza

// wyświetlamy formularz
?>
<h2>Podaj datę początku oraz końca zdarzenia</h2>
<form action="data_czas.php" method="post">

  <p><label for="start">Data początku:</label> <input type="date" name="start" value="<?php echo $start->format($format); ?>"> (YYYY-MM-DD)</p>
  <p><label for="end">Data końca:</label> <input type="date" name="end" value="<?php echo $end->format($format); ?>"> (YYYY-MM-DD)</p>

  <p><input type="submit" value="Prześlij"></p>
</form>
</body>
</html>