<?php # Listing 13.8 - login_functions.inc.php #2
// Ten skrypt definiuje dwie funkcje używane w procesie logowania/wylogowania.

/* Funkcja określa i zwraca bezwzblędny adres URL po czym przekierowuje użytkownika na tę stronę.
 * Funkcja ma jeden argument: stronę na która należy przekierować użytkownika.
 * Domyślną wartością argumentu jest index.php.
 */
function redirect_user($page = 'index.php') {

  // zaczynamy definiowanie adresu URL...
  // adres URL to http:// + nazwa hosta + bieżący katalog:
  $url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);

  // usuwamy znaki odwrotnego ukośnika z końca adresu
  $url = rtrim($url, '/\\');

  // dodajemy stronę
  $url .= '/' . $page;

  // wykonujemy przekierowanie
  header("Location: $url");
  exit(); // kończymy działanie skryptu

} // koniec funkcji redirect_user().


/* Funkcja weryfikuje dane wprowadzone w formularzu (adres e-mail i hasło).
 * Jeśli obie wartości zostały wprowadzone, wysyła zapytanie do bazy danych.
 * Funkcja wymaga przekazania połączenia z bazą danych.
 * Zwraca tablicę zawierającą:
 * - wartość TRUE lub FALSE oznaczającą wynik logowania
 * - tablicę błędów lub danych pobranych z bazy
 */
function check_login($dbc, $email = '', $pass = '') {

  $errors = []; // incjujemy tablicę błędów

  // sprawdzamy adres e-mail
  if (empty($email)) {
    $errors[] = 'Zapomniałeś wprowadzić adres e-mail.';
  } else {
    $e = mysqli_real_escape_string($dbc, trim($email));
  }

  // sprawdzamy hasło
  if (empty($pass)) {
    $errors[] = 'Zapomniałeś podać hasło.';
  } else {
    $p = trim($pass);
  }

  if (empty($errors)) { // jeśli wszystko w porządku

    // pobieramy user_id i first_name dla podanej kombinacji e-mail/hasło
    $q = "SELECT user_id, first_name FROM users WHERE email='$e'";
    $r = @mysqli_query($dbc, $q); // Run the query.

    // sprawdzamy wyniki
    if (mysqli_num_rows($r) == 1) {

      // pobieramy rekord
      $row = mysqli_fetch_array($r, MYSQLI_ASSOC);

      // zwracamy true oraz rekord
      if (password_verify($p, $row['pass'])) {
        unset($row['pass']);
        return [true, $row];
      } else {
        $errors[] = 'Wprowadzone adres i hasło nie odpowiadają przechowywanym w bazie danych.';
      }

    } else { // nie znaleziono dopasowania
      $errors[] = 'Wprowadzone adres i hasło nie odpowiadają przechowywanym w bazie danych.';
    }

  } // koniec instrukcji IF empty($errors)

  // zwracamy false i tablicę z komunikatami o błędach
  return [false, $errors];

} // koniec funkcji check_login()