<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Przesyłanie obrazka na serwer</title>
  <style>
  .error {
    font-weight: bold;
    color: #C00;
  }
  </style>
</head>
<body>
<?php # Listing 11.2 - przeslij_obrazek.php

// sprawdzamy czy formularz został przesłany
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // sprawdzamy czy został przesłany obrazek
  if (isset($_FILES['upload'])) {

    // sprawdzamy typ pliku; powinien być JPEG lub PNG
    $allowed = ['image/pjpeg', 'image/jpeg', 'image/JPG', 'image/X-PNG', 'image/PNG', 'image/png', 'image/x-png'];
    if (in_array($_FILES['upload']['type'], $allowed)) {

      // przenosimy przesłany plik
      if (move_uploaded_file ($_FILES['upload']['tmp_name'], "../uploads/{$_FILES['upload']['name']}")) {
        echo '<p><em>Plik został przesłany na serwer!</em></p>';
      } // koniec przenoszenia pliku IF.

    } else { // przesłano plik nieodpowiedniego typu
      echo '<p class="error">Można przesyłać jedynie obrazy typu JPEG lub PNG.</p>';
    }

  } // koniec instrukcji IF isset($_FILES['upload'])

  // sprawdzamy czy podczas przesyłania pliku wystąpiły błędy
  if ($_FILES['upload']['error'] > 0) {
    echo '<p class="error">Nie udało się przesłać pliku na serwer! Powód: <strong>';

    // wyświetlamy komunikat zależny od rodzaju błędu
    switch ($_FILES['upload']['error']) {
      case 1:
        print 'Rozmiar pliku jest większy od ustawienia upload_max_filesize w pliku php.ini.';
        break;
      case 2:
        print 'Rozmiar pliku większy niż określony przez parametr MAX_FILE_SIZE formularza HTML.';
        break;
      case 3:
        print 'Plik został przesłany tylko częściowo.';
        break;
      case 4:
        print 'Nie przesłano żadnego pliku.';
        break;
      case 6:
        print 'Katalog tymczasowy był niedostępny.';
        break;
      case 7:
        print 'Brak możliwości zapisu pliku na dysk.';
        break;
      case 8:
        print 'Proces przesyłania pliku został przerwany.';
        break;
      default:
        print 'Wystąpił błąd systemowy.';
        break;
    } // koniec instrukcji switch.

    print '</strong></p>';

  } // koniec instrukcji IF związanej z obsługą błędów

  // usuwamy plik jeśli jeszcze istnieje
  if (file_exists ($_FILES['upload']['tmp_name']) && is_file($_FILES['upload']['tmp_name']) ) {
    unlink ($_FILES['upload']['tmp_name']);
  }

} // koniec głównej instrukcji IF
?>

<form enctype="multipart/form-data" action="upload_image.php" method="post">

  <input type="hidden" name="MAX_FILE_SIZE" value="524288">

  <fieldset><legend>Prześlij na serwer plik JPEG lub PNG o wielkości do 512KB:</legend>

  <p><strong>Plik:</strong> <input type="file" name="upload"></p>

  </fieldset>
  <div align="center"><input type="submit" name="submit" value="Prześlij"></div>

</form>
</body>
</html>