<?php # Listing 10.2 - usun_uzytkownika.php
// Ten skrypt służy do usuwania użytkownika.
// Jest używany przez pokaz_uzytkownika.php.

$page_title = 'Usuń użytkownika';
include ('includes/naglowek.html');
echo '<h1>Usuń użytkownika</h1>';

// sprawdzamy poprawność identyfikatora użytkownika, przekazanego za pomocą GET lub POST.
if ( (isset($_GET['id'])) && (is_numeric($_GET['id'])) ) { // przekazany ze skryptu pokaz_uzytkownika.php
  $id = $_GET['id'];
} elseif ( (isset($_POST['id'])) && (is_numeric($_POST['id'])) ) { // przesłanie formularza
  $id = $_POST['id'];
} else { // brak poprawnego identyfikatora, zakończymy skrypt
  echo '<p class="error">Błąd dostępu do strony.</p>';
  include ('includes/stopka.html'); 
  exit();
}

require('../mysqli_connect.php');

// sprawdzamy, czy formularz został wysłany
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  if ($_POST['sure'] == 'Yes') { // usuwamy rekord

    // towrzymy polecenie DELETE
    $q = "DELETE FROM users WHERE user_id=$id LIMIT 1";   
    $r = @mysqli_query ($dbc, $q);
    if (mysqli_affected_rows($dbc) == 1) { // jeśli zostało wykonane pomyślnie
    
      // wyświetlamy komunikat
      echo '<p>Użytkownik został usunięty.</p>';  
    
    } else { // jeśli zapytanie nie zostało wykonane poprawnie
      echo '<p class="error">Użytkownik nie został usunięty z powodu błędu systemu.</p>'; // komunikat dla użytkownika
      echo '<p>' . mysqli_error($dbc) . '<br>Zapytanie: ' . $q . '</p>'; // komunikat uruchomieniowy
    }
  
  } else { // użytkownik nie potwierdził usunięcia
    echo '<p>Użytkownik NIE został usunięty.</p>';  
  }

} else { // wyświetlamy formularz

  // pobieramy informacje o użytkowniku
  $q = "SELECT CONCAT(last_name, ', ', first_name) FROM users WHERE user_id=$id";
  $r = @mysqli_query ($dbc, $q);
  
  if (mysqli_num_rows($r) == 1) { // Jeśli identyfikator był poprawny, to wyświetl formularz.

    // pobierzamy informacje o użytkowniku
    $row = mysqli_fetch_array ($r, MYSQLI_NUM);
    
    // wyświetlamy rekord, który ma zostać usunięty
    echo "<h3>Nazwisko: $row[0]</h3>
    Czy na pewno chcesz usunąć tego użytkownika?";

    // generujemy formularz
    echo '<form action="usun_uzytkownika.php" method="post">
      <input type="radio" name="sure" value="Yes" /> Tak
      <input type="radio" name="sure" value="No" checked="checked" /> Nie</p>
      <p><input type="submit" name="submit" value="Wyślij" /></p>
      <input type="hidden" name="id" value="' . $id . '" />
      </form>';
  
  } else { // nie przekazano prawidłowego identyfikatora użytkownika
    echo '<p class="error">Błąd podczas dostępu do strony.</p>';
  }

} // koniec głównej instrukcji if.

mysqli_close($dbc);
    
include ('includes/stopka.html');
?>