<?php # Listing 3.5 - kalkulator.php

$page_title = 'Kalkulator kosztów podróży!';
include ('includes/naglowek.html');

// Sprawdzamy czy formularz został wysłany.
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // Bardzo prosta weryfikacja danych z formularza:
  if (isset($_POST['distance'], $_POST['fuel_price'], $_POST['efficiency']) && 
   is_numeric($_POST['distance']) && is_numeric($_POST['fuel_price']) && is_numeric($_POST['efficiency']) ) {

    // Wyliczamy wyniki:
    $gallons = $_POST['distance'] / $_POST['efficiency'];
    $dollars = $gallons * $_POST['fuel_price'];
    $hours = $_POST['distance']/75;

    // Wyświetlamy wyniki:
    echo '<div class="page-header"><h1>Szacunkowy koszt całkowity</h1></div>
    <p>Całkowity koszt przejechania ' . $_POST['distance'] . ' kilometrów, przy średnim zużyciu ' . $_POST['efficiency'] . ' kilometrów na litr i przy średniej cenie ' . $_POST['fuel_price'] . ' zł za litr, wynosi ' . number_format($dollars, 2) . ' zł. Gdybyś jechał z prędkością 75 kilometrów na godzinę, podróż zajęłaby około ' . number_format($hours, 2) . ' godzin.</p>';

  } else { // Przesłano nieprawidłowe dane.
    echo '<div class="page-header"><h1>Błąd!</h1></div>
    <p class="text-danger">Proszę prawidłowo podać dystans oraz wybrać cenę paliwa i jego zużycie.</p>';
  }

} // Koniec obsługi formularza IF.

// Koniec sekcji PHP i początek formularza HTML:
?>

<div class="page-header"><h1>Kalkulator kosztów podróży</h1></div>
<form action="kalkulator.php" method="post">
  <p>Dystans (w kilometrach): <input type="number" name="distance"></p>
  <p>Średnia cena za litr paliwa:
    <input type="radio" name="fuel_price" value="4.50"> 4.50
    <input type="radio" name="fuel_price" value="4.65"> 4.65
    <input type="radio" name="fuel_price" value="4.80"> 4.80
  </p>
  <p>Zużycie paliwa: <select name="efficiency">
    <option value="12.5">Duże</option>
    <option value="14.2">Przeciętne</option>
    <option value="16.6">Niskie</option>
    <option value="20">Rewelacyjne</option>
  </select></p>
  <p><input type="submit" name="submit" value="Oblicz!"></p>
</form>

<?php include ('includes/stopka.html'); ?>