<?php # Skrypt 14.10 - view_cart.php
// Ta strona wywietla zawarto koszyka.
// Pozwala rwnie na zmian zawartoci koszyka.

// Ustawiamy tytu strony i doczamy nagwek HTML.
$page_title = 'Zawarto koszyka';
include ('./includes/header.html');

// Sprawdzamy, czy formularz zosta przesany (w celu zaktualizowania koszyka).
if (isset($_POST['submitted'])) {

  // Zmieniamy ilo produktw.
  foreach ($_POST['qty'] as $k => $v) {
  
    // Tylko liczby cakowite!
    $pid = (int) $k;
    $qty = (int) $v;
    
    if ( $qty == 0 ) { // Usuwamy.    
      unset ($_SESSION['cart'][$pid]);      
    } elseif ( $qty > 0 ) { // Zmieniamy ilo.    
      $_SESSION['cart'][$pid]['quantity'] = $qty;      
    }
    
  } // Koniec instrukcji FOREACH.
} // Koniec instrukcji sprawdzajcej, czy formularz zosta przesany

// Sprawdzamy, czy koszyk jest pusty.
$empty = TRUE;
if (isset ($_SESSION['cart'])) {
  foreach ($_SESSION['cart'] as $key => $value) {
    if (isset($value)) {
      $empty = FALSE;  
      break; // Wychodzimy z ptli.
    }
  } // Koniec instrukcji FOREACH.
} // Koniec instrukcji warunkowej ISSET.

// Wywietlamy koszyk, jeli nie jest pusty.
if (!$empty) {

  require_once ('../mysql_connect.php'); // czymy si z baz danych.

  // Pobieramy wszystkie informacje o odbitkach w koszyku.
  $query = "SELECT print_id, CONCAT_WS(' ', first_name, middle_name, last_name) AS name, print_name FROM artists, prints WHERE artists.artist_id = prints.artist_id AND prints.print_id IN (";
  foreach ($_SESSION['cart'] as $pid => $value) {
    $query .= $pid . ',';
  }
  $query = substr ($query, 0, -1) . ') ORDER BY artists.last_name ASC';
  $result = mysqli_query ($dbc, $query);
  
  // Tworzymy tabel i formularz.
  echo '<table border="0" width="90%" cellspacing="3" cellpadding="3" align="center">
  <tr>
    <td align="left" width="30%"><b>Artysta</b></td>
    <td align="left" width="30%"><b>Nazwa odbitki</b></td>
    <td align="right" width="10%"><b>Cena</b></td>
    <td align="center" width="10%"><b>Ilo</b></td>
    <td align="right" width="12%"><b>Kwota</b></td>
  </tr>
<form action="view_cart.php" method="post">
';

  // Wywietlamy poszczeglne odbitki.
  $total = 0; // czna kwota zamwienia.
  while ($row = mysqli_fetch_array ($result, MYSQLI_ASSOC)) {
    
    // Obliczamy sum i sumy czciowe.
    $subtotal = $_SESSION['cart'][$row['print_id']]['quantity'] * $_SESSION['cart'][$row['print_id']]['price'];
    $total += $subtotal;
    
    // Wywietlamy wiersz.
    echo "  <tr>
    <td align=\"left\">{$row['name']}</td>
    <td align=\"left\">{$row['print_name']}</td>
    <td align=\"right\">" . number_format ($_SESSION['cart'][$row['print_id']]['price'], 2, ',', ' ') . " z </td>
    <td align=\"center\"><input type=\"text\" size=\"3\" name=\"qty[{$row['print_id']}]\" value=\"{$_SESSION['cart'][$row['print_id']]['quantity']}\" /></td>
    <td align=\"right\">" . number_format ($subtotal, 2, ',', ' ') . " z</td>
  </tr>\n";
  } // Koniec ptli WHILE.
  
  mysqli_close($dbc); // Zamykamy poczenie z baz danych.

  // Wywietlamy stopk, zamykamy tabel i formularz.
  echo '  <tr>
    <td colspan="4" align="right"><b>Suma:<b></td>
    <td align="right">' . number_format ($total, 2, ',', ' ') . ' z</td>
  </tr>
  </table><div align="center"><input type="submit" name="submit" value="Aktualizuj koszyk" />  
  <input type="hidden" name="submitted" value="TRUE" />
</form><br /><br /><a href="submit_order.php"><font size="+2">Z zamwienie</font></a></div>';

} else {
  echo '<p>Twj koszyk jest obecnie pusty.</p>';
}

include ('./includes/footer.html');
?>
