<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-2" />
	<title>Instrukcje przygotowane</title>
</head>
<body>
<?php # Skrypt 11.7 - prepared.php

// Nawizujemy poczenie.
$dbc = @mysqli_connect ('localhost', 'username', 'password', 'test') OR die ('Nie udao si poczy z MySQL: ' . mysqli_connect_error() );

// Tworzymy zapytanie.
$query = "INSERT INTO accounts (name, balance) VALUES (?, ?)";

// Przygotowujemy instrukcj.
$stmt = mysqli_prepare($dbc, $query);

// Wiemy zmienne.
mysqli_stmt_bind_param($stmt, "sd", $name, $balance);

// Tworzymy tablic wartoci przeznaczonych do wstawienia.
$data = array(
	array('Italo Calvino', 65465.99),
	array('Vladimir Nabokov', 132.74),
	array('James Joyce', 432.74),
	array('William Faulkner', 841664.67),
	array('F. Scott Fitzgerald', 69.23),
	array('Zora Neale Hurston', 130654.44),
	array('Franz Kafka', 87.63),
	array('William Carlos Williams', 9.98),
	array('Jane Austen', 1324.02),
	array('George Eliot', 49683.56)
);

// Wywietlamy podpis.
echo "<p>Przygotowane zapytanie: $query</p>\n";

// Przetwarzamy tablic w ptli, kolejno wstawiajc kady rekord.
foreach ($data as $record) {

	// Przypisujemy wartoci zmiennym.
	$name = $record[0];
	$balance = $record[1];
	
	// Wykonujemy zapytanie.
	mysqli_stmt_execute($stmt);
	
	// Wywietlamy wyniki.
	echo "<p>Nazwisko: $name<br />Saldo: $balance<br />Wynik: ";
	
	// Wywietlamy komunikat na podstawie wyniku.
	if (mysqli_stmt_affected_rows($stmt) == 1) {
		echo 'OK';
	} else {
		echo 'BD' . mysqli_stmt_error($stmt);
	}
	
	echo '</p>';
	
} // Koniec ptli foreach.

// Zamykamy instrukcj.
mysqli_stmt_close($stmt);

// Zamykamy poczenie.
mysqli_close($dbc);
?>
</body>
</html>