<?php # Skrypt 13.9 - logout.php
// Strona umoliwiajca wylogowanie si z witryny.

// Doczamy plik konfiguracyjny z procedurami obsugi bdw.
require_once ('./includes/config.inc.php'); 

// Ustawiamy tytu strony i doczamy nagwek HTML.
$page_title = 'Wylogowanie';
include ('./includes/header.html');

// Jeli nie istnieje zmienna first_name, przekierowujemy uytkownika.
if (!isset($_SESSION['first_name'])) {

  // Zaczynamy definicj adresu URL.
  $url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
  // Sprawdzamy kocowy ukonik.
  if ((substr($url, -1) == '/') OR (substr($url, -1) == '\\') ) {
    $url = substr ($url, 0, -1); // Odcinamy ukonik.
  }
  // Dodajemy stron.
  $url .= '/index.php';
  
  ob_end_clean(); // Usuwamy bufor.
  header("Location: $url");
  exit(); // Koczymy dziaanie skryptu.
  
} else { // Wylogowujemy uytkownika.

  $_SESSION = array(); // Usuwamy zmienne.
  session_destroy(); // Usuwamy sam sesj.
  setcookie (session_name(), '', time()-300, '/', '', 0); // Usuwamy plik cookie.

}

// Wywietlamy komunikat.
echo "<h3>Zostae wylogowany.</h3>";

include ('./includes/footer.html');
?>
