<?php
declare(strict_types = 1);                                          // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                               // Importowanie klasy

include '../src/bootstrap.php';                                     // Plik konfiguracyjny

$bledy = [];                                                        // Inicjalizacja zmiennej

$token = $_GET['token'] ?? '';                                      // Pobierz token
if (!$token) {                                                      // Jeśli id nie został zwrócony
    przekieruj('logowanie.php');                                    // Przekieruj
}

$id = $cms->pobierzToken()->pobierzIdUczestnika($token, 'reset_hasla');   // Pobierz id użytkownika
if (!$id) {                                                               // Jeśli id nie istnieje
    przekieruj('logowanie.php', ['ostrzezenie' => 'Ważność odsyłacza wygasła, spróbuj ponownie.',]); // Przekieruj
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                         // Jeśli formularz został przesłany
    $haslo = $_POST['haslo'];                                       // Pobierz nowe hasło
    $potwierdzenie  = $_POST['potwierdzenie'];                      // Pobierz potwierdzenie hasła

    // Zweryfikuj siłę hasła i dopasowanie w obu polach
    $bledy['haslo'] = Weryfikacja::czyHaslo($haslo)
        ? '' : 'Hasło musi się składać z co najmniej 8 znaków, w tym:<br> 
                Małej litery<br>Dużej litery<br>Cyfry
                <br>Znaku specjalnego';                             // Nieprawidłowe hasło
    $bledy['potwierdzenie']  = ($haslo === $potwierdzenie)
        ? '' : 'Niezgodne hasła';                                   // Hasła różnią się
    $nieprawidlowe = implode($bledy);                               // Połącz komunikaty błędów

    if ($nieprawidlowe) {                                           // Jeśli hasło jest niepoprawne
        $bledy['wiadomosc'] = 'Proszę wprowadzić prawidłowe hasło.';// Zapisz komunikat błędu
    } else {                                                        // W przeciwnym razie
        $cms->pobierzUczestnika()->aktualizacjaHasla($id, $haslo);  // Zaktualizuj hasło
        $uczestnik  = $cms->pobierzUczestnika()->pobierz($id);      // Pobierz dane o użytkowniku
        $temat = 'Hasło zostało zaktualizowane';                    // Utwórz temat i treść
        $tresc    = 'Twoje hasło zostało zmienione dnia ' . date('Y-m-d H:i:s') .
            ' - jeśli nie resetowałeś hasła, wyślij email ' . $ustaw_email['admin_email'];
        $email   = new \PhpMysql\Email\Email($ustaw_email);         // Utwórz nowy obiekt Email
        // Wyślij e-mail
        $email->wyslijEmail($ustaw_email['admin_email'], $uczestnik['email'], $temat, $tresc);
        przekieruj('logowanie.php', ['sukces' => 'Hasło zostało zmienione']); // Przekieruj na stronę logowania
    }
}

$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();   // Kategorie do nawigacji 
$dane['bledy']     = $bledy;                                        // Tablica błędów
$dane['token']     = $token;                                        // Token

echo $twig->render('resetowanie-hasla.html', $dane);                // Wyrenderuj szablon