<?php
declare(strict_types = 1);                                 // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                      // Zaimportuj klasę Weryfikacja

include '../src/bootstrap.php';                            // Plik konfiguracyjny

$email   = '';                                             // Zainicjalizuj zmienną $email 
$bledy  = [];                                              // Zainicjalizuj tablicę $bledy
$sukces = $_GET['sukces'] ?? null;                         // Pobierz wiadomość o powodzeniu

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                // Jeśli formularz został przesłany
    $email    = $_POST['email'];                           // Pobierz adres e-mail
    $haslo = $_POST['haslo'];                              // Pobierz hasło

    $bledy['email']    = Weryfikacja::czyEmail($email)
        ? '' : 'Proszę wprowadzić prawidłowy adres e-mail';// Zweryfikuj e-mail
    $bledy['haslo'] = Weryfikacja::czyHaslo($haslo)
        ? '' : 'Hasło musi się składać z co najmniej 8 znaków, w tym:<br> 
                Małej litery<br>Dużej litery<br>Cyfry
                <br>Znaku specjalnego';                    // Zweryfikuj hasło
    $nieprawidlowe = implode($bledy);                      // Połącz błędy

    if ($nieprawidlowe) {                                           // Jeśli dane są niepoprawne
        $bledy['wiadomosc'] = 'Proszę spróbować jeszcze raz.';      // Zapisz komunikat błędu
    } else {                                                        // Jeśli dane są poprawne
        $uczestnik = $cms->pobierzUczestnika()->logowanie($email, $haslo); // Pobierz informacje o użytkowniku
        if ($uczestnik and $uczestnik['rola'] == 'zawieszony') {    // Jeśli użytkownik jest zawieszony
            $bledy['wiadomosc'] = 'Konto zawieszone';               // Zapisz komunikat
        } elseif ($uczestnik) {                                     // W przeciwnym razie 
            $cms->pobierzSesje()->utworz($uczestnik);               // Utwórz sesję dla użytkownika
            przekieruj('uczestnik.php', ['id' => $uczestnik['id'],]);  // Przekieruj go na jego stronę
        } else {                                                    // Jeśli użytkownik nie istnieje
            $bledy['wiadomosc'] = 'Proszę spróbować jeszcze raz.';  // Zapisz komunikat błędu
        }
    }
}

$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();   // Pobierz kategorie nawigacji
$dane['sukces']    = $sukces;                              // Wiadomość o powodzeniu
$dane['email']     = $email;                               // Adres e-mail w razie nieudanego logowania
$dane['bledy']     = $bledy;                               // Tablica błędów

echo $twig->render('logowanie.html', $dane);               // Wyrenderuj szablon