<?php
declare(strict_types = 1);                                    // Użyj ścisłej kontroli typów
require 'dolaczane/polaczenie-baza.php';                      // Utwórz obiekt PDO
require 'dolaczane/funkcje.php';                              // Dołącz funkcje

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);     // Sprawdź id
if (!$id) {                                                   // W razie nieprawidłowego id
    include 'nie-odnaleziono-strony.php';                     // Nie odnaleziono strony
}

$sql = "SELECT imie, nazwisko, dolaczyl, zdjecie FROM uczestnicy WHERE id = :id;"; // SQL
$uczestnik = pdo($pdo, $sql, [$id])->fetch();                 // Pobierz dane o użytkowniku
if (!$uczestnik) {                                            // Jeśli tablica jest pusta
    include 'nie-odnaleziono-strony.php';                     // Nie odnaleziono strony
}

$sql = "SELECT p.id, p.tytul, p.podsumowanie, p.id_kategorii, p.id_uczestnika, 
               k.nazwa      AS kategoria,
               CONCAT(u.imie, ' ', u.nazwisko) AS autor,
               o.plik       AS obraz_plik,
               o.alt        AS obraz_alt 
          FROM publikacje   AS p
          JOIN kategorie    AS k   ON p.id_kategorii = k.id
          JOIN uczestnicy   AS u   ON p.id_uczestnika   = u.id
          LEFT JOIN obrazy  AS o   ON p.id_obrazu    = o.id
         WHERE p.id_uczestnika = :id AND p.opublikowano  = 1
         ORDER BY p.id DESC;";                                 // SQL
$publikacje = pdo($pdo, $sql, [$id])->fetchAll();              // Publikacje uczestnika

$sql = "SELECT id, nazwa FROM kategorie WHERE nawigacja = 1;"; // Zapytanie SQL o kategorie
$nawigacja  = pdo($pdo, $sql)->fetchAll();                     // Pobierz kategorie do nawigacji
$sekcja     = '';                                              // Bieżąca kategoria
$tytul       = $uczestnik['imie'] . ' ' . $uczestnik['nazwisko']; // Zawartość znacznika <title>
$opis = $tytul . ' z Creative Folk';                           // Opis do znacznika <meta>
?>
<?php include 'dolaczane/naglowek.php'; ?>
  <main class="container" id="content">
    <section class="header">
      <h1><?= zastap_html($uczestnik['imie'] . ' ' . $uczestnik['nazwisko']) ?></h1>
      <p class="member"><b>Uczestnik od:</b> <?= formatuj_date($uczestnik['dolaczyl']) ?></p>
      <img src="wyslane/<?= zastap_html($uczestnik['zdjecie'] ?? 'uczestnik.png') ?>"
           alt="<?= zastap_html($uczestnik['nazwisko']) ?>" class="profile"><br>
    </section>
    <section class="grid">
    <?php foreach ($publikacje as $publikacja) { ?>
      <article class="summary">
        <a href="publikacja.php?id=<?= $publikacja['id'] ?>">
          <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
               alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
          <h2><?= zastap_html($publikacja['tytul']) ?></h2>
          <p><?= zastap_html($publikacja['podsumowanie']) ?></p>
        </a>
        <p class="credit">
          Zamieszczono w <a href="kategoria.php?id=<?= $publikacja['id_kategorii'] ?>">
          <?= zastap_html($publikacja['kategoria']) ?></a>
          przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
        </p>
      </article>
    <?php } ?>
    </section>
  </main>
<?php include 'dolaczane/stopka.php'; ?>