<?php
// CZĘŚĆ A: Konfiguracja
use PhpMysql\Weryfikacja\Weryfikacja;                        // Zaimportuj przestrzeń Weryfikacja
czyAdmin($sesja->rola);                                      // Sprawdź status administratora

// Inicjalizacja zmiennej potrzebnej w kodzie PHP
$zapisano = null;                                            // Czy kategoria została zapisana

// Inicjalizacja zmiennych potrzebnych w kodzie HTML
$kategoria = [];                                             // Inicjalizacja tablicy kategorii
$bledy   = [];                                               // Inicjalizacja tablicy błędów

if ($id) {                                                   // Jeśli jest id i formularz nie był przesłany
    $kategoria = $cms->pobierzKategorie()->pobierz($id);     // Pobierz dane kategorii
    if (!$kategoria) {                                       // Jeśli nie ma danych kategorii
        przekieruj('/admin/kategorie/', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
    }
}

// CZĘŚĆ B: Pobierz i zweryfikuj dane z formularza
if ($_SERVER['REQUEST_METHOD'] == 'POST') {                  // Jeśli formularz przesłany
    $kategoria['nazwa']        = $_POST['nazwa'];            // Pobierz nazwę
    $kategoria['opis'] = $_POST['opis'];                     // Pobierz opis
    $kategoria['nawigacja']  = isset($_POST['nawigacja']) ? 1 : 0; // Pobierz nawigację
    $kategoria['seo_nazwa']    = utworz_nazwe_seo($kategoria['nazwa']);  // Nazwa przyjazna SEO

    $bledy['nazwa']          = (Weryfikacja::czyTekst($kategoria['nazwa'], 1, 24))
        ? '' : 'Nazwa powinna się składać z 1-24 znaków.';   // Sprawdź nazwę
    $bledy['opis']   = (Weryfikacja::czyTekst($kategoria['opis'], 1, 254))
        ? '' : 'Opis powinien się składać z 1-254 znaków.';  // Sprawdź opis
    $nieprawidlowe                 = implode($bledy);        // Połącz komunikaty błędów

    // CZĘŚĆ C: Sprawdź prawidłowość danych i zaktualizuj bazę
    if ($nieprawidlowe) {                                    // Jeśli dane są niepoprawne
        $bledy['ostrzezenie'] = 'Proszę poprawić błędy';     // Komunikat błędu
    } else {                                                 // W przeciwnym razie utwórz / zaktualizuj
        if ($id) {                                           // Jeśli jest id
            $zapisano = $cms->pobierzKategorie()->aktualizuj($kategoria); // Spróbuj zaktualizować kategorię
        } else {                                             // Jeśli nie ma id
            $zapisano = $cms->pobierzKategorie()->utworz($kategoria); // Spróbuj utworzyć kategorię
        }
        if ($zapisano === true) {                            // W razie powodzenia
            przekieruj('admin/kategorie/', ['sukces' => 'Kategoria została zapisana']); // Przekieruj
        }
        if ($zapisano === false) {                           // Jeśli kategoria się powtarza
            $bledy['ostrzezenie'] = 'Nazwa kategorii jest już używana'; // Zapisz komunikat błędu
        }
    }
}

$dane['kategoria'] = $kategoria;                             // Dodaj kategorie do szablonu
$dane['bledy']   = $bledy;                                   // Dodaj błędy do szablonu

echo $twig->render('admin/kategoria.html', $dane);           // Wyrenderuj szablon Twiga